/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    @Override
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        if (listStacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStacksRequest> request = new DefaultRequest<ListStacksRequest>(listStacksRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStacksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listStacksRequest.getNextToken()));
        }
        if (listStacksRequest.getStackStatusFilters().isEmpty() && !((SdkInternalList)listStacksRequest.getStackStatusFilters()).isAutoConstruct()) {
            request.addParameter("StackStatusFilter", "");
        }
        if (!listStacksRequest.getStackStatusFilters().isEmpty() || !((SdkInternalList)listStacksRequest.getStackStatusFilters()).isAutoConstruct()) {
            SdkInternalList stackStatusFiltersList = (SdkInternalList)listStacksRequest.getStackStatusFilters();
            int stackStatusFiltersListIndex = 1;
            for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                if (stackStatusFiltersListValue != null) {
                    request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex, StringUtils.fromString(stackStatusFiltersListValue));
                }
                ++stackStatusFiltersListIndex;
            }
        }
        return request;
    }
}

