/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.edgedeploy.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private static final int BUFFER_SIZE = 1024;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ZipOutputStream zip = new ZipOutputStream(this.output);

    public void writeEntry(String name, byte[] content) throws IOException {
        this.writeEntry(name, () -> this.zip.write(content));
    }

    public void writeEntry(String name, InputStream stream) throws IOException {
        this.writeEntry(name, () -> {
            int count;
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) > 0) {
                this.zip.write(buffer, 0, count);
            }
        });
    }

    private void writeEntry(String name, ContentWriter handler) throws IOException {
        this.zip.putNextEntry(new ZipEntry(name));
        handler.write();
        this.zip.closeEntry();
    }

    public ByteBuffer dump() throws IOException {
        this.zip.close();
        this.output.close();
        return ByteBuffer.wrap(this.output.toByteArray());
    }

    @FunctionalInterface
    private static interface ContentWriter {
        public void write() throws IOException;
    }
}

