/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.invoke;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import com.amazonaws.services.lambda.invoke.DefaultLambdaFunctionNameResolver;
import com.amazonaws.services.lambda.invoke.LambdaFunction;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.amazonaws.services.lambda.invoke.LambdaFunctionNameResolver;
import com.amazonaws.services.lambda.invoke.LambdaInvokerFactoryConfig;
import com.amazonaws.services.lambda.invoke.LambdaSerializationException;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.LogType;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LambdaInvokerFactory {
    static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    @Deprecated
    public static <T> T build(Class<T> interfaceClass, AWSLambda awsLambda) {
        return LambdaInvokerFactory.build(interfaceClass, awsLambda, new LambdaInvokerFactoryConfig());
    }

    @Deprecated
    public static <T> T build(Class<T> interfaceClass, AWSLambda awsLambda, LambdaInvokerFactoryConfig config) {
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LambdaInvocationHandler(interfaceClass, awsLambda, config));
        return interfaceClass.cast(proxy);
    }

    public static Builder builder() {
        return new Builder();
    }

    private LambdaInvokerFactory() {
    }

    private static class LambdaInvocationHandler
    implements InvocationHandler {
        private final AWSLambda awsLambda;
        private final Log log;
        private final LambdaInvokerFactoryConfig config;
        private final ObjectMapper mapper;

        public LambdaInvocationHandler(Class<?> interfaceClass, AWSLambda awsLambda, LambdaInvokerFactoryConfig config) {
            this.awsLambda = awsLambda;
            this.log = LogFactory.getLog(interfaceClass);
            this.config = config;
            this.mapper = config.getObjectMapper();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            LambdaFunction annotation = this.validateInterfaceMethod(method, args);
            InvokeRequest invokeRequest = this.buildInvokeRequest(method, annotation, args == null ? null : args[0]);
            InvokeResult invokeResult = this.awsLambda.invoke(invokeRequest);
            return this.processInvokeResult(method, invokeResult);
        }

        private LambdaFunction validateInterfaceMethod(Method method, Object[] args) {
            LambdaFunction annotation = method.getAnnotation(LambdaFunction.class);
            if (annotation == null) {
                throw new LambdaSerializationException("No LambdaFunction annotation for method " + method.getName());
            }
            if (annotation.invocationType() != InvocationType.RequestResponse && annotation.logType() != LogType.None) {
                throw new LambdaSerializationException("InvocationType must be RequestResponse if LogType is set");
            }
            if (args != null && args.length > 1) {
                throw new LambdaSerializationException("LambdaFunctions take either 0 or 1 arguments");
            }
            return annotation;
        }

        private InvokeRequest buildInvokeRequest(Method method, LambdaFunction annotation, Object input) {
            InvokeRequest invokeRequest = new InvokeRequest();
            String functionName = this.config.getLambdaFunctionNameResolver().getFunctionName(method, annotation, this.config);
            invokeRequest.setFunctionName(functionName);
            if (this.hasQualifier()) {
                invokeRequest.setQualifier(this.getQualifier());
            }
            invokeRequest.setInvocationType(annotation.invocationType());
            invokeRequest.setLogType(annotation.logType());
            if (input != null) {
                try {
                    String payload = this.mapper.writer().writeValueAsString(input);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Serialized request object to '" + payload + "'");
                    }
                    invokeRequest.setPayload(payload);
                }
                catch (JsonProcessingException ex) {
                    throw new LambdaSerializationException("Failed to serialize request object to JSON", ex);
                }
            }
            return invokeRequest;
        }

        private boolean hasQualifier() {
            return this.getQualifier() != null;
        }

        private String getQualifier() {
            return this.config.getFunctionAlias() == null ? this.config.getFunctionVersion() : this.config.getFunctionAlias();
        }

        private Object processInvokeResult(Method method, InvokeResult invokeResult) throws Throwable {
            String functionError;
            if (invokeResult.getLogResult() != null && this.log.isInfoEnabled()) {
                try {
                    String decoded = new String(Base64.decode(invokeResult.getLogResult()), StringUtils.UTF8);
                    this.log.info(method.getName() + " log:\n\t" + decoded.replaceAll("\n", "\n\t"));
                }
                catch (Exception ex) {
                    this.log.warn("Error decoding log result '" + invokeResult.getLogResult() + "'", ex);
                }
            }
            if ((functionError = invokeResult.getFunctionError()) == null) {
                return this.getObjectFromPayload(method, invokeResult);
            }
            throw this.getExceptionFromPayload(method, invokeResult);
        }

        private Object getObjectFromPayload(Method method, InvokeResult invokeResult) {
            try {
                return this.getObjectFromPayload(method.getGenericReturnType(), invokeResult.getPayload());
            }
            catch (IOException ex) {
                throw new LambdaSerializationException("Failed to parse Lambda function result", ex);
            }
        }

        private Throwable getExceptionFromPayload(Method method, InvokeResult invokeResult) {
            try {
                LambdaFunctionException error = this.getObjectFromPayload(LambdaFunctionException.class, invokeResult.getPayload());
                error.setFunctionError(invokeResult.getFunctionError());
                error.fillInStackTrace(method.getDeclaringClass());
                return this.getExceptionToThrow(method, error);
            }
            catch (Exception ex) {
                this.log.warn("Error parsing exception information from response payload", ex);
                return new LambdaFunctionException("Unexpected error executing Lambda function", invokeResult.getFunctionError());
            }
        }

        private Throwable getExceptionToThrow(Method method, LambdaFunctionException error) {
            String type = error.getType();
            Constructor<?> constructor = this.findConstructor(this.findCustomExceptionClass(method, type));
            if (constructor != null) {
                try {
                    Throwable toReturn = (Throwable)constructor.newInstance(error.getMessage());
                    toReturn.setStackTrace(error.getStackTrace());
                    return toReturn;
                }
                catch (Exception ex) {
                    this.log.warn("Error constructing custom exception", ex);
                }
            }
            return error;
        }

        private Class<?> findCustomExceptionClass(Method method, String type) {
            if (type != null) {
                for (Class<?> exceptionType : method.getExceptionTypes()) {
                    if (!exceptionType.getName().equals(type) && !exceptionType.getSimpleName().equals(type)) continue;
                    return exceptionType;
                }
            }
            return null;
        }

        private Constructor<?> findConstructor(Class<?> type) {
            if (type == null) {
                return null;
            }
            for (Constructor<?> constructor : type.getConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params == null || params.length != 1 || !String.class.equals(params[0])) continue;
                return constructor;
            }
            return null;
        }

        private <T> T getObjectFromPayload(Class<T> type, ByteBuffer payload) throws IOException {
            return type.cast(this.getObjectFromPayload((Type)type, payload));
        }

        private Object getObjectFromPayload(Type type, ByteBuffer payload) throws IOException {
            if (type == Void.TYPE || payload.remaining() == 0) {
                return null;
            }
            JavaType javaType = this.mapper.getTypeFactory().constructType(type);
            return this.mapper.reader(javaType).readValue(BinaryUtils.copyAllBytesFrom(payload));
        }
    }

    public static class Builder {
        private LambdaFunctionNameResolver functionNameResolver;
        private String functionAlias;
        private String functionVersion;
        private AWSLambda lambda;
        private ObjectMapper objectMapper;

        public Builder lambdaFunctionNameResolver(LambdaFunctionNameResolver functionNameResolver) {
            this.functionNameResolver = functionNameResolver;
            return this;
        }

        private LambdaFunctionNameResolver resolveFunctionNameResolver() {
            return this.functionNameResolver == null ? new DefaultLambdaFunctionNameResolver() : this.functionNameResolver;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            if (objectMapper.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                throw new IllegalArgumentException("FAIL_ON_UNKNOWN_PROPERTIES must be disabled on any custom ObjectMapper used");
            }
            this.objectMapper = objectMapper;
            return this;
        }

        private ObjectMapper resolveObjectMapper() {
            return null != this.objectMapper ? this.objectMapper : DEFAULT_MAPPER;
        }

        public Builder functionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
            return this;
        }

        public Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public Builder lambdaClient(AWSLambda lambda) {
            this.lambda = lambda;
            return this;
        }

        private AWSLambda resolveLambdaClient() {
            return this.lambda == null ? AWSLambdaAsyncClientBuilder.defaultClient() : this.lambda;
        }

        public <T> T build(Class<T> interfaceClass) {
            return LambdaInvokerFactory.build(interfaceClass, this.resolveLambdaClient(), this.getConfiguration());
        }

        private LambdaInvokerFactoryConfig getConfiguration() {
            return new LambdaInvokerFactoryConfig(this.resolveFunctionNameResolver(), this.resolveObjectMapper(), this.functionAlias, this.functionVersion);
        }
    }
}

