/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.sns;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.PublishResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class TopicClient {
    private AmazonSNS sns;
    private ObjectMapper objectMapper;
    private String topicArn;

    public TopicClient(ObjectMapper objectMapper, String topicArn) {
        this((AmazonSNS)AmazonSNSClientBuilder.standard().build(), objectMapper, topicArn);
    }

    public PublishResult publish(Object message) throws JsonProcessingException {
        return this.sns.publish(this.topicArn, this.objectMapper.writeValueAsString(message));
    }

    public TopicClient(AmazonSNS sns, ObjectMapper objectMapper, String topicArn) {
        this.sns = sns;
        this.objectMapper = objectMapper;
        this.topicArn = topicArn;
    }
}

