/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.GetSMSAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSMSAttributesRequestMarshaller
implements Marshaller<Request<GetSMSAttributesRequest>, GetSMSAttributesRequest> {
    @Override
    public Request<GetSMSAttributesRequest> marshall(GetSMSAttributesRequest getSMSAttributesRequest) {
        if (getSMSAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSMSAttributesRequest> request = new DefaultRequest<GetSMSAttributesRequest>(getSMSAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!getSMSAttributesRequest.getAttributes().isEmpty() || !((SdkInternalList)getSMSAttributesRequest.getAttributes()).isAutoConstruct()) {
            SdkInternalList attributesList = (SdkInternalList)getSMSAttributesRequest.getAttributes();
            int attributesListIndex = 1;
            for (String attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    request.addParameter("attributes.member." + attributesListIndex, StringUtils.fromString(attributesListValue));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

