/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.cform.organization.service;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.organizations.AWSOrganizations;
import com.amazonaws.services.organizations.model.CreateOrganizationRequest;
import com.amazonaws.services.organizations.model.DeleteOrganizationRequest;
import com.amazonaws.services.organizations.model.DescribeOrganizationRequest;
import com.amazonaws.services.organizations.model.ListRootsRequest;
import com.amazonaws.services.organizations.model.Organization;
import com.amazonaws.services.organizations.model.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;
import pl.wrzasq.lambda.cform.organization.model.OrganizationRequest;
import pl.wrzasq.lambda.cform.organization.model.OrganizationWithRoot;

public class OrganizationManager {
    private static final String DRIFT_LOG_MESSAGE_PATTERN = "Organization ID {} differs from CloudFormation-provided physical resource ID {}.";
    private Logger logger = LoggerFactory.getLogger(OrganizationManager.class);
    private AWSOrganizations organizations;

    public OrganizationManager(AWSOrganizations organizations) {
        this.organizations = organizations;
    }

    public CustomResourceResponse<OrganizationWithRoot> sync(OrganizationRequest input, String physicalResourceId) {
        Organization organization;
        try {
            organization = this.organizations.describeOrganization(new DescribeOrganizationRequest()).getOrganization();
            if (!organization.getId().equals(physicalResourceId)) {
                this.logger.warn(DRIFT_LOG_MESSAGE_PATTERN, (Object)organization.getId(), (Object)physicalResourceId);
            }
            this.logger.info("Organization already exists (ARN {}).", (Object)organization.getArn());
        }
        catch (SdkBaseException error) {
            this.logger.info("Exception occurred during organization data fetching, probably doesn't exist.", error);
            organization = this.organizations.createOrganization(new CreateOrganizationRequest().withFeatureSet(input.getFeatureSet())).getOrganization();
            this.logger.info("Created new organization, ARN {}.", (Object)organization.getArn());
        }
        Root root = this.organizations.listRoots(new ListRootsRequest()).getRoots().get(0);
        return new CustomResourceResponse<OrganizationWithRoot>(new OrganizationWithRoot(organization, root), organization.getId());
    }

    public CustomResourceResponse<OrganizationWithRoot> delete(OrganizationRequest input, String physicalResourceId) {
        Organization organization = this.organizations.describeOrganization(new DescribeOrganizationRequest()).getOrganization();
        if (!organization.getId().equals(physicalResourceId)) {
            this.logger.error(DRIFT_LOG_MESSAGE_PATTERN, (Object)organization.getId(), (Object)physicalResourceId);
            throw new IllegalStateException(String.format("Can not delete Organization - ID %s doesn't match CloudFormation-provided resource ID %s.", organization.getId(), physicalResourceId));
        }
        this.organizations.deleteOrganization(new DeleteOrganizationRequest());
        this.logger.info("Organization deleted.");
        return new CustomResourceResponse<Object>(null, physicalResourceId);
    }
}

