/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.xray.plugins.Plugin;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElasticBeanstalkPlugin
implements Plugin {
    private static final Log logger = LogFactory.getLog(ElasticBeanstalkPlugin.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, Object> runtimeContext = new HashMap<String, Object>();
    private static final String CONF_PATH = "/var/elasticbeanstalk/xray/environment.conf";
    private static final String SERVICE_NAME = "elastic_beanstalk";
    private static final String ORIGIN = "AWS::ElasticBeanstalk::Environment";

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void populateRuntimeContext() {
        byte[] manifestBytes = new byte[]{};
        try {
            manifestBytes = Files.readAllBytes(Paths.get(CONF_PATH, new String[0]));
        }
        catch (IOException | OutOfMemoryError | SecurityException e) {
            logger.warn("Unable to read Beanstalk configuration at path /var/elasticbeanstalk/xray/environment.conf : " + e.getMessage());
            return;
        }
        try {
            TypeReference<HashMap<String, Object>> typeReference = new TypeReference<HashMap<String, Object>>(){};
            this.runtimeContext = (Map)this.objectMapper.readValue(manifestBytes, (TypeReference)typeReference);
        }
        catch (IOException e) {
            logger.warn("Unable to read Beanstalk configuration at path /var/elasticbeanstalk/xray/environment.conf : " + e.getMessage());
            return;
        }
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        this.populateRuntimeContext();
        return this.runtimeContext;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }
}

