/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.config;

import com.amazonaws.xray.entities.StringValidator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaemonConfiguration {
    private static final Log logger = LogFactory.getLog(DaemonConfiguration.class);
    private static final int DEFAULT_PORT = 2000;
    private static final String DEFAULT_ADDRESS = "127.0.0.1:2000";
    private String TCPAddress;
    private String UDPAddress;
    public InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 2000);
    public static final String DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY = "AWS_XRAY_DAEMON_ADDRESS";
    public static final String DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY = "com.amazonaws.xray.emitters.daemonAddress";

    public DaemonConfiguration() {
        String environmentAddress = System.getenv(DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY);
        String systemAddress = System.getProperty(DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY);
        if (this.setUDPAndTCPAddress(environmentAddress)) {
            try {
                this.parseAndModifyDaemonAddress(this.getUDPAddress());
            }
            catch (IllegalArgumentException | SecurityException e) {
                logger.error("Error switching to provided daemon address " + environmentAddress + " set by environment variable " + DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY + ". Using loopback address by default.");
            }
        } else if (StringValidator.isNotNullOrBlank(systemAddress)) {
            try {
                this.parseAndModifyDaemonAddress(systemAddress);
                logger.info("System property com.amazonaws.xray.emitters.daemonAddress is set. Emitting to daemon on address " + this.address.toString());
            }
            catch (IllegalArgumentException | SecurityException e) {
                logger.error("Error switching to provided daemon address " + systemAddress + " set by system property " + DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY + ". Using loopback address by default.");
            }
        } else {
            this.setUDPAddress(DEFAULT_ADDRESS);
            this.setTCPAddress(DEFAULT_ADDRESS);
        }
    }

    public void setDaemonAddress(String socketAddress) {
        String environmentAddress = System.getenv(DAEMON_ADDRESS_ENVIRONMENT_VARIABLE_KEY);
        String systemAddress = System.getProperty(DAEMON_ADDRESS_SYSTEM_PROPERTY_KEY);
        if (StringValidator.isNullOrBlank(environmentAddress) && StringValidator.isNullOrBlank(systemAddress)) {
            this.parseAndModifyDaemonAddress(socketAddress);
        } else {
            logger.info("Ignoring call to setDaemonAddress as AWS_XRAY_DAEMON_ADDRESS is set.");
        }
    }

    public boolean setUDPAndTCPAddress(String addr) {
        if (StringValidator.isNotNullOrBlank(addr)) {
            String[] splitStr = addr.split("\\s+");
            if (splitStr.length > 2) {
                logger.error("Invalid value for agent address: " + addr + ". Value must be of form \"ip_address:port\" or \"tcp:ip_address:port udp:ip_address:port\".");
                return false;
            }
            if (splitStr.length == 1) {
                this.setTCPAddress(addr);
                this.setUDPAddress(addr);
                return true;
            }
            if (splitStr.length == 2) {
                String[] part1 = splitStr[0].split(":");
                String[] part2 = splitStr[1].split(":");
                if (part1.length != 3 && part2.length != 3) {
                    logger.error("Invalid value for agent address: " + splitStr[0] + " and " + splitStr[1] + ". Value must be of form \"tcp:ip_address:port udp:ip_address:port\".");
                    return false;
                }
                HashMap<String, String[]> mapping = new HashMap<String, String[]>();
                mapping.put(part1[0], part1);
                mapping.put(part2[0], part2);
                String[] TCPInfo = (String[])mapping.get("tcp");
                String[] UDPInfo = (String[])mapping.get("udp");
                this.setTCPAddress(TCPInfo[1] + ":" + TCPInfo[2]);
                this.setUDPAddress(UDPInfo[1] + ":" + UDPInfo[2]);
                return true;
            }
        }
        return false;
    }

    private void parseAndModifyDaemonAddress(String socketAddress) {
        int lastColonIndex = socketAddress.lastIndexOf(58);
        if (-1 == lastColonIndex) {
            throw new IllegalArgumentException("Invalid value for agent address: " + socketAddress + ". Value must be of form \"ip_address:port\".");
        }
        String[] parts = socketAddress.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid value for agent address: " + socketAddress + ". Value must be of form \"ip_address:port\".");
        }
        this.address = new InetSocketAddress(socketAddress.substring(0, lastColonIndex), Integer.parseInt(socketAddress.substring(lastColonIndex + 1, socketAddress.length())));
    }

    public void setTCPAddress(String addr) {
        logger.debug("TCPAddress is set to " + addr + ".");
        this.TCPAddress = addr;
    }

    public String getTCPAddress() {
        return this.TCPAddress;
    }

    public void setUDPAddress(String addr) {
        logger.debug("UDPAddress is set to " + addr + ".");
        this.UDPAddress = addr;
    }

    public String getUDPAddress() {
        return this.UDPAddress;
    }

    public String getEndpointForTCPConnection() {
        String[] parts = this.getTCPAddress().split(":");
        if (parts.length != 2) {
            return "http://127.0.0.1:2000";
        }
        return "http://" + this.getTCPAddress();
    }
}

