/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.lambda;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHandler {
    private Logger logger = LoggerFactory.getLogger(MultiHandler.class);
    private ObjectMapper objectMapper;
    private List<CallHandler> handlers = new ArrayList<CallHandler>();

    public MultiHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void registerHandler(CallHandler handler) {
        this.handlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(inputStream);
            for (CallHandler handler : this.handlers) {
                this.logger.trace("Attempting {} to handle payload.", (Object)this.handlers.getClass().getName());
                if (handler.handle(root, outputStream)) {
                    this.logger.trace("Handled.");
                    return;
                }
                this.logger.trace("Skipping.");
            }
            this.logger.error("No handler was able to handle payload {}.", (Object)this.objectMapper.writeValueAsBytes(root));
        }
        finally {
            outputStream.close();
        }
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @FunctionalInterface
    public static interface CallHandler {
        public boolean handle(JsonNode var1, OutputStream var2);
    }
}

