/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

public class SearchPattern {
    public static boolean wildcardMatch(String pattern, String text) {
        return SearchPattern.wildcardMatch(pattern, text, true);
    }

    public static boolean wildcardMatch(String pattern, String text, boolean caseInsensitive) {
        int indexOfGlob;
        if (pattern == null || text == null) {
            return false;
        }
        int patternLength = pattern.length();
        int textLength = text.length();
        if (patternLength == 0) {
            return textLength == 0;
        }
        if (SearchPattern.isWildcardGlob(pattern)) {
            return true;
        }
        if (caseInsensitive) {
            pattern = pattern.toLowerCase();
            text = text.toLowerCase();
        }
        if ((indexOfGlob = pattern.indexOf(42)) == -1 || indexOfGlob == patternLength - 1) {
            return SearchPattern.simpleWildcardMatch(pattern, text);
        }
        boolean[] res = new boolean[textLength + 1];
        res[0] = true;
        for (int j = 0; j < patternLength; ++j) {
            int i;
            char p = pattern.charAt(j);
            if (p != '*') {
                for (i = textLength - 1; i >= 0; --i) {
                    char t = text.charAt(i);
                    res[i + 1] = res[i] && (p == '?' || p == t);
                }
            } else {
                for (i = 0; i <= textLength && !res[i]; ++i) {
                }
                while (i <= textLength) {
                    res[i] = true;
                    ++i;
                }
            }
            res[0] = res[0] && p == '*';
        }
        return res[textLength];
    }

    private static boolean simpleWildcardMatch(String pattern, String text) {
        int j = 0;
        int patternLength = pattern.length();
        int textLength = text.length();
        for (int i = 0; i < patternLength; ++i) {
            char p = pattern.charAt(i);
            if (p == '*') {
                return true;
            }
            if (p == '?') {
                if (j == textLength) {
                    return false;
                }
                ++j;
                continue;
            }
            if (j >= textLength) {
                return false;
            }
            char t = text.charAt(j);
            if (p != t) {
                return false;
            }
            ++j;
        }
        return j == textLength;
    }

    private static boolean isWildcardGlob(String pattern) {
        return pattern.length() == 1 && pattern.charAt(0) == '*';
    }
}

