/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.contexts;

import com.amazonaws.xray.contexts.LambdaSegmentContext;
import com.amazonaws.xray.contexts.SegmentContext;
import com.amazonaws.xray.contexts.SegmentContextResolver;
import com.amazonaws.xray.entities.StringValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LambdaSegmentContextResolver
implements SegmentContextResolver {
    private static final Log logger = LogFactory.getLog(LambdaSegmentContextResolver.class);
    private static final String LAMBDA_TASK_ROOT_KEY = "LAMBDA_TASK_ROOT";
    private static final String SDK_INITIALIZED_FILE_LOCATION = "/tmp/.aws-xray/initialized";

    private static String getLambdaTaskRoot() {
        return System.getenv(LAMBDA_TASK_ROOT_KEY);
    }

    @Override
    public SegmentContext resolve() {
        String lambdaTaskRootValue = LambdaSegmentContextResolver.getLambdaTaskRoot();
        if (StringValidator.isNotNullOrBlank(lambdaTaskRootValue)) {
            logger.debug("LAMBDA_TASK_ROOT is set. Lambda context detected.");
            return new LambdaSegmentContext();
        }
        return null;
    }

    static {
        if (StringValidator.isNotNullOrBlank(LambdaSegmentContextResolver.getLambdaTaskRoot())) {
            boolean success = true;
            long now = System.currentTimeMillis();
            File f = new File(SDK_INITIALIZED_FILE_LOCATION);
            f.getParentFile().mkdirs();
            try {
                FileOutputStream out = new FileOutputStream(f);
                ((OutputStream)out).close();
                Files.setAttribute(f.toPath(), "lastAccessTime", FileTime.fromMillis(now), new LinkOption[0]);
            }
            catch (IOException ioe) {
                success = false;
            }
            if (!success || !f.setLastModified(now)) {
                logger.warn("Unable to write to /tmp/.aws-xray/initialized. Failed to signal SDK initialization.");
            }
        }
    }
}

