/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.organizations.model.Handshake;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class HandshakeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<List> PARTIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parties").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> REQUESTEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EXPIRATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final HandshakeMarshaller instance = new HandshakeMarshaller();

    public static HandshakeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Handshake handshake, ProtocolMarshaller protocolMarshaller) {
        if (handshake == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(handshake.getId(), ID_BINDING);
            protocolMarshaller.marshall(handshake.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(handshake.getParties(), PARTIES_BINDING);
            protocolMarshaller.marshall(handshake.getState(), STATE_BINDING);
            protocolMarshaller.marshall(handshake.getRequestedTimestamp(), REQUESTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(handshake.getExpirationTimestamp(), EXPIRATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(handshake.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall(handshake.getResources(), RESOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

