/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.organizations.model.HandshakeResourceType;
import com.amazonaws.services.organizations.model.transform.HandshakeResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HandshakeResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String value;
    private String type;
    private List<HandshakeResource> resources;

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public HandshakeResource withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public HandshakeResource withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(HandshakeResourceType type) {
        this.withType(type);
    }

    public HandshakeResource withType(HandshakeResourceType type) {
        this.type = type.toString();
        return this;
    }

    public List<HandshakeResource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<HandshakeResource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<HandshakeResource>(resources);
    }

    public HandshakeResource withResources(HandshakeResource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<HandshakeResource>(resources.length));
        }
        for (HandshakeResource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public HandshakeResource withResources(Collection<HandshakeResource> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeResource)) {
            return false;
        }
        HandshakeResource other = (HandshakeResource)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public HandshakeResource clone() {
        try {
            return (HandshakeResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

