/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.openapi;

import com.google.common.collect.Range;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.sparkbit.commons.openapi.JavaBeansAwarePropertyCustomizer;
import pl.sparkbit.commons.openapi.PropertyCustomizersKt;
import pl.sparkbit.commons.openapi.SizeCustomizer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J.\u0010\f\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/sparkbit/commons/openapi/SizeCustomizer;", "Lpl/sparkbit/commons/openapi/JavaBeansAwarePropertyCustomizer;", "()V", "log", "Lmu/KLogger;", "applySize", "", "property", "Lio/swagger/v3/oas/models/media/Schema;", "range", "Lcom/google/common/collect/Range;", "", "customize", "parent", "elementDescriptor", "Ljavax/validation/metadata/ElementDescriptor;", "sparkbit-commons"})
public final class SizeCustomizer
implements JavaBeansAwarePropertyCustomizer {
    @NotNull
    private final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Schema<?> customize(@NotNull Schema<?> property, @Nullable Schema<?> parent, @NotNull ElementDescriptor elementDescriptor) {
        Object v1;
        boolean bl;
        ConstraintDescriptor it$iv$iv;
        Iterable $this$firstOrNull$iv$iv$iv;
        boolean $i$f$lookup;
        Iterable $this$lookup$iv$iv;
        ElementDescriptor $this$lookup$iv;
        block5: {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)elementDescriptor, (String)"elementDescriptor");
            $this$lookup$iv = elementDescriptor;
            boolean $i$f$lookup2 = false;
            Set set = $this$lookup$iv.getConstraintDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.constraintDescriptors");
            $this$lookup$iv$iv = set;
            $i$f$lookup = false;
            $this$firstOrNull$iv$iv$iv = $this$lookup$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                it$iv$iv = (ConstraintDescriptor)element$iv$iv$iv;
                bl = false;
                if (!(it$iv$iv.getAnnotation() instanceof Size)) continue;
                v1 = element$iv$iv$iv;
                break block5;
            }
            v1 = null;
        }
        ConstraintDescriptor constraintDescriptor = v1;
        ConstraintDescriptor constraintDescriptor2 = constraintDescriptor;
        if (constraintDescriptor == null) {
            Object v6;
            block6: {
                void $this$flatMapTo$iv$iv$iv;
                Set set = $this$lookup$iv.getConstraintDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.constraintDescriptors");
                Iterable $this$flatMap$iv$iv = set;
                boolean $i$f$flatMap = false;
                $this$firstOrNull$iv$iv$iv = $this$flatMap$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv$iv : $this$flatMapTo$iv$iv$iv) {
                    ConstraintDescriptor it$iv = (ConstraintDescriptor)element$iv$iv$iv;
                    boolean bl2 = false;
                    Set set2 = it$iv.getComposingConstraints();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.composingConstraints");
                    Iterable list$iv$iv$iv = set2;
                    CollectionsKt.addAll((Collection)destination$iv$iv$iv, (Iterable)list$iv$iv$iv);
                }
                $this$flatMap$iv$iv = (List)destination$iv$iv$iv;
                $i$f$lookup = false;
                $this$firstOrNull$iv$iv$iv = $this$lookup$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                    it$iv$iv = (ConstraintDescriptor)element$iv$iv$iv;
                    bl = false;
                    if (!(it$iv$iv.getAnnotation() instanceof Size)) continue;
                    v6 = element$iv$iv$iv;
                    break block6;
                }
                v6 = null;
            }
            constraintDescriptor2 = v6;
        }
        ConstraintDescriptor size = constraintDescriptor2;
        if (size != null) {
            Range range = Range.closed((Comparable)Integer.valueOf(((Size)size.getAnnotation()).min()), (Comparable)Integer.valueOf(((Size)size.getAnnotation()).max()));
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"closed(size.annotation.min, size.annotation.max)");
            this.applySize(property, (Range<Integer>)range);
        }
        return property;
    }

    private final void applySize(Schema<?> property, Range<Integer> range) {
        Schema<?> schema = property;
        if (schema instanceof StringSchema) {
            Range existingRange2 = PropertyCustomizersKt.buildRange$default(property, applySize.existingRange.1.INSTANCE, applySize.existingRange.2.INSTANCE, null, null, 12, null);
            Range newRange = existingRange2.intersection(range);
            property.minLength((Integer)newRange.lowerEndpoint());
            property.maxLength((Integer)newRange.upperEndpoint());
        } else if (schema instanceof ArraySchema) {
            Range existingRange3 = PropertyCustomizersKt.buildRange$default(property, applySize.existingRange.3.INSTANCE, applySize.existingRange.4.INSTANCE, null, null, 12, null);
            Range newRange = existingRange3.intersection(range);
            property.minItems((Integer)newRange.lowerEndpoint());
            property.maxItems((Integer)newRange.upperEndpoint());
        } else {
            this.log.warn((Function0)new Function0<Object>(range, property){
                final /* synthetic */ Range<Integer> $range;
                final /* synthetic */ Schema<?> $property;
                {
                    this.$range = $range;
                    this.$property = $property;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Cannot apply size constraint " + this.$range + " to schema " + this.$property.getClass().getName() + " - type is unsupported";
                }
            });
        }
    }
}

