/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u000f\u001a\u00060\u000bR\u00020\u0000H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0002H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\t\u00a8\u0006\u0017"}, d2={"Lpl/sparkbit/commons/logging/OutputSizeCappingFilter;", "Lch/qos/logback/core/filter/Filter;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "epochLengthMillis", "", "getEpochLengthMillis", "()J", "setEpochLengthMillis", "(J)V", "latestEpochCounter", "Lpl/sparkbit/commons/logging/OutputSizeCappingFilter$EpochBytesCounter;", "maxBytes", "getMaxBytes", "setMaxBytes", "currentEpoch", "decide", "Lch/qos/logback/core/spi/FilterReply;", "event", "toString", "", "estimateMessageSizeInBytes", "EpochBytesCounter", "sparkbit-commons"})
public final class OutputSizeCappingFilter
extends Filter<ILoggingEvent> {
    private long maxBytes = 60000000L;
    private long epochLengthMillis = 60000L;
    @NotNull
    private EpochBytesCounter latestEpochCounter = new EpochBytesCounter(0L);

    public final long getMaxBytes() {
        return this.maxBytes;
    }

    public final void setMaxBytes(long l) {
        this.maxBytes = l;
    }

    public final long getEpochLengthMillis() {
        return this.epochLengthMillis;
    }

    public final void setEpochLengthMillis(long l) {
        this.epochLengthMillis = l;
    }

    @NotNull
    public FilterReply decide(@NotNull ILoggingEvent event) {
        FilterReply filterReply;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EpochBytesCounter epoch = this.currentEpoch();
        long newBytes = this.estimateMessageSizeInBytes(event);
        long totalSize = epoch.incrementCounter(newBytes);
        if (totalSize > this.maxBytes) {
            epoch.reportOnce();
            filterReply = FilterReply.DENY;
        } else {
            filterReply = FilterReply.NEUTRAL;
        }
        return filterReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EpochBytesCounter currentEpoch() {
        long newEpochIdentifier = System.currentTimeMillis() / this.epochLengthMillis;
        OutputSizeCappingFilter outputSizeCappingFilter = this;
        synchronized (outputSizeCappingFilter) {
            boolean bl = false;
            if (newEpochIdentifier > this.latestEpochCounter.getEpochIdentifier()) {
                this.latestEpochCounter = new EpochBytesCounter(newEpochIdentifier);
            }
            EpochBytesCounter epochBytesCounter = this.latestEpochCounter;
            return epochBytesCounter;
        }
    }

    private final long estimateMessageSizeInBytes(ILoggingEvent $this$estimateMessageSizeInBytes) {
        Object it;
        long sum = 0L;
        Object[] objectArray = $this$estimateMessageSizeInBytes.getMessage();
        if (objectArray != null) {
            it = objectArray;
            boolean bl = false;
            sum += (long)(((String)it).length() * 2);
        }
        Object[] objectArray2 = $this$estimateMessageSizeInBytes.getArgumentArray();
        if (objectArray2 != null) {
            it = objectArray2;
            boolean bl = false;
            sum += (long)(((Object[])it).length * 50);
        }
        String string = $this$estimateMessageSizeInBytes.getLoggerName();
        if (string != null) {
            it = string;
            boolean bl = false;
            sum += (long)(((String)it).length() * 2);
        }
        for (IThrowableProxy t = $this$estimateMessageSizeInBytes.getThrowableProxy(); t != null; t = t.getCause()) {
            StackTraceElementProxy[] it2;
            sum += (long)(t.getClassName().length() * 2);
            if (t.getMessage() != null) {
                String it3;
                boolean bl = false;
                sum += (long)(it3.length() * 2);
            }
            if (t.getStackTraceElementProxyArray() == null) continue;
            boolean bl = false;
            sum += (long)(it2.length * 80);
        }
        return sum;
    }

    @NotNull
    public String toString() {
        return "OutputSizeCappingFilter" + this.getName();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/sparkbit/commons/logging/OutputSizeCappingFilter$EpochBytesCounter;", "", "epochIdentifier", "", "(Lpl/sparkbit/commons/logging/OutputSizeCappingFilter;J)V", "bytesCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getEpochIdentifier", "()J", "reported", "", "incrementCounter", "newBytes", "reportOnce", "", "sparkbit-commons"})
    private final class EpochBytesCounter {
        private final long epochIdentifier;
        @NotNull
        private final AtomicLong bytesCounter;
        private boolean reported;

        public EpochBytesCounter(long epochIdentifier) {
            this.epochIdentifier = epochIdentifier;
            this.bytesCounter = new AtomicLong(0L);
        }

        public final long getEpochIdentifier() {
            return this.epochIdentifier;
        }

        public final long incrementCounter(long newBytes) {
            return this.bytesCounter.addAndGet(newBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reportOnce() {
            EpochBytesCounter epochBytesCounter = this;
            synchronized (epochBytesCounter) {
                boolean bl = false;
                if (this.reported) {
                    return;
                }
                this.reported = true;
                Unit unit = Unit.INSTANCE;
            }
            OutputSizeCappingFilter.this.context.getStatusManager().add((Status)new WarnStatus("Log size limit reached  - " + OutputSizeCappingFilter.this.getMaxBytes() + " bytes. New messages will not be appended for a while.", (Object)OutputSizeCappingFilter.this));
        }
    }
}

