/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.mybatis.metrics;

import java.time.Duration;
import java.time.Instant;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import pl.sparkbit.commons.mybatis.metrics.MyBatisMetricsCollector;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PerformancePlugin
implements Interceptor {
    private final MyBatisMetricsCollector collector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Instant start = Instant.now();
        Object firstArg = invocation.getArgs()[0];
        MappedStatement ms = (MappedStatement)firstArg;
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            Instant end = Instant.now();
            this.collector.recordSQLStatementExecutionTime(ms.getId(), Duration.between(start, end));
            this.collector.recordSQLStatement(ms.getId());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public PerformancePlugin(MyBatisMetricsCollector collector) {
        this.collector = collector;
    }
}

