/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.mail;

import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.SendGrid;
import com.sendgrid.helpers.mail.Mail;
import com.sendgrid.helpers.mail.objects.Email;
import com.sendgrid.helpers.mail.objects.Personalization;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.sparkbit.commons.exception.InternalException;
import pl.sparkbit.commons.mail.MailProperties;
import pl.sparkbit.commons.mail.MailService;

public class SendGridMailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(SendGridMailServiceImpl.class);
    private static final String MAIL_SEND_ENDPOINT = "mail/send";
    private static final String TEMPLATE_VARIABLE_MARKER = "%";
    private final SendGrid sendGrid;
    private final MailProperties mailProperties;

    public SendGridMailServiceImpl(MailProperties mailProperties) {
        this.sendGrid = new SendGrid(mailProperties.getSendgridApiKey());
        this.mailProperties = mailProperties;
    }

    @Override
    public void sendMail(String templateId, String to) {
        this.sendMail(templateId, to, this.mailProperties.getDefaultSenderAddress(), this.mailProperties.getDefaultSenderName(), Collections.emptyMap());
    }

    @Override
    public void sendMail(String templateId, String to, Map<String, String> params) {
        this.sendMail(templateId, to, this.mailProperties.getDefaultSenderAddress(), this.mailProperties.getDefaultSenderName(), params);
    }

    @Override
    public void sendMail(String templateId, String to, String senderAddress, String senderName) {
        this.sendMail(templateId, to, senderAddress, senderName, Collections.emptyMap());
    }

    @Override
    public void sendMail(String templateId, String to, String senderAddress, String senderName, Map<String, String> params) {
        Mail mail = new Mail();
        mail.setFrom(new Email(senderAddress, senderName));
        mail.setTemplateId(templateId);
        Personalization personalization = new Personalization();
        personalization.addTo(new Email(to));
        params.forEach((key, value) -> personalization.addSubstitution(SendGridMailServiceImpl.formatTemplateVariableKey(key), value));
        mail.addPersonalization(personalization);
        Request request = new Request();
        request.setMethod(Method.POST);
        request.setEndpoint(MAIL_SEND_ENDPOINT);
        try {
            request.setBody(mail.build());
            this.sendGrid.api(request);
        }
        catch (IOException e) {
            throw new InternalException("Sending email failed", e);
        }
    }

    private static String formatTemplateVariableKey(String key) {
        return TEMPLATE_VARIABLE_MARKER + key + TEMPLATE_VARIABLE_MARKER;
    }
}

