/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.sparkbit.commons.json.JsonField;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00012\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00000\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/sparkbit/commons/jackson/JsonFieldDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdScalarDeserializer;", "Lpl/sparkbit/commons/json/JsonField;", "Lcom/fasterxml/jackson/databind/deser/ContextualDeserializer;", "()V", "cache", "Lcom/google/common/cache/Cache;", "Lcom/fasterxml/jackson/databind/JavaType;", "wrapped", "(Lcom/google/common/cache/Cache;Lcom/fasterxml/jackson/databind/JavaType;)V", "createContextual", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "property", "Lcom/fasterxml/jackson/databind/BeanProperty;", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "deserializationContext", "getNullValue", "sparkbit-commons"})
public class JsonFieldDeserializer
extends StdScalarDeserializer<JsonField<?>>
implements ContextualDeserializer {
    @NotNull
    private final Cache<JavaType, JsonFieldDeserializer> cache;
    @Nullable
    private final JavaType wrapped;

    public JsonFieldDeserializer(@NotNull Cache<JavaType, JsonFieldDeserializer> cache, @Nullable JavaType wrapped) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        super(JsonField.class);
        this.cache = cache;
        this.wrapped = wrapped;
    }

    public JsonFieldDeserializer() {
        Cache cache = CacheBuilder.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder().build<JavaT\u2026 JsonFieldDeserializer>()");
        this((Cache<JavaType, JsonFieldDeserializer>)cache, null);
    }

    @NotNull
    public JsonField<?> deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext deserializationContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
        Intrinsics.checkNotNullParameter((Object)deserializationContext, (String)"deserializationContext");
        if (!(this.wrapped != null)) {
            boolean bl = false;
            String string = "Unknown wrapped type";
            throw new IllegalStateException(string.toString());
        }
        JsonDeserializer deserializer = deserializationContext.findNonContextualValueDeserializer(this.wrapped);
        JsonField<Object> jsonField = JsonField.wrap(deserializer.deserialize(jp, deserializationContext));
        Intrinsics.checkNotNullExpressionValue(jsonField, (String)"wrap(deserializer.deseri\u2026 deserializationContext))");
        return jsonField;
    }

    @Nullable
    public JsonField<?> getNullValue(@Nullable DeserializationContext ctxt) {
        return JsonField.wrap(null);
    }

    @NotNull
    public JsonDeserializer<?> createContextual(@NotNull DeserializationContext ctxt, @NotNull BeanProperty property) {
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        JavaType wrappedType = property.getType().getBindings().getBoundType(0);
        Object object = this.cache.get((Object)wrappedType, () -> JsonFieldDeserializer.createContextual$lambda-1(this, wrappedType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache.get(wrappedType) {\u2026e, wrappedType)\n        }");
        return (JsonDeserializer)object;
    }

    private static final JsonFieldDeserializer createContextual$lambda-1(JsonFieldDeserializer this$0, JavaType $wrappedType) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new JsonFieldDeserializer(this$0.cache, $wrappedType);
    }
}

