/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.actuator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import pl.sparkbit.commons.actuator.EcsMetadataInfoContributor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0007RB\u0010\u0005\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006j\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/sparkbit/commons/actuator/EcsMetadataInfoContributor;", "Lorg/springframework/boot/actuate/info/InfoContributor;", "metadataUri", "", "(Ljava/lang/String;)V", "details", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "log", "Lmu/KLogger;", "contribute", "", "builder", "Lorg/springframework/boot/actuate/info/Info$Builder;", "setup", "sparkbit-commons"})
public final class EcsMetadataInfoContributor
implements InfoContributor {
    @NotNull
    private final String metadataUri;
    @NotNull
    private final HashMap<String, Map<String, Object>> details;
    @NotNull
    private final KLogger log;

    public EcsMetadataInfoContributor(@NotNull String metadataUri) {
        Intrinsics.checkNotNullParameter((Object)metadataUri, (String)"metadataUri");
        this.metadataUri = metadataUri;
        this.details = new HashMap();
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @PostConstruct
    public final void setup() {
        if (((CharSequence)this.metadataUri).length() > 0) {
            ResponseEntity $this$getForEntity$iv;
            RestTemplate restTemplate = new RestTemplate();
            try {
                void url$iv;
                RestOperations restOperations = (RestOperations)restTemplate;
                String string = this.metadataUri;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                ResponseEntity responseEntity2 = $this$getForEntity$iv.getForEntity((String)url$iv, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity2, (String)"getForEntity(url, T::class.java, *uriVariables)");
                $this$getForEntity$iv = responseEntity2;
            }
            catch (ResourceAccessException e) {
                this.log.warn((Function0)new Function0<Object>(e){
                    final /* synthetic */ ResourceAccessException $e;
                    {
                        this.$e = $e;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Can't access metadata endpoint: " + this.$e.getMessage();
                    }
                });
                return;
            }
            ResponseEntity responseEntity3 = $this$getForEntity$iv;
            if (responseEntity3.getStatusCode().is2xxSuccessful()) {
                Map metadata = (Map)responseEntity3.getBody();
                if (metadata != null) {
                    HashMap ecsDetails = new HashMap();
                    ((Map)ecsDetails).put("docker-id", metadata.getOrDefault("DockerId", ""));
                    ((Map)ecsDetails).put("docker-name", metadata.getOrDefault("DockerName", ""));
                    ((Map)ecsDetails).put("image", metadata.getOrDefault("Image", ""));
                    ((Map)ecsDetails).put("image-id", metadata.getOrDefault("ImageID", ""));
                    ((Map)ecsDetails).put("created-at", metadata.getOrDefault("CreatedAt", ""));
                    ((Map)ecsDetails).put("started_at", metadata.getOrDefault("StartedAt", ""));
                    ((Map)ecsDetails).put("type", metadata.getOrDefault("Type", ""));
                    Object v = metadata.get("Labels");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    Map labels = (Map)v;
                    ((Map)ecsDetails).put("cluster", labels.getOrDefault("com.amazonaws.ecs.cluster", ""));
                    ((Map)ecsDetails).put("container-name", labels.getOrDefault("com.amazonaws.ecs.container-name", ""));
                    ((Map)ecsDetails).put("task-arn", labels.getOrDefault("com.amazonaws.ecs.task-arn", ""));
                    ((Map)ecsDetails).put("task-definition-family", labels.getOrDefault("com.amazonaws.ecs.task-definition-family", ""));
                    ((Map)ecsDetails).put("task-definition-version", labels.getOrDefault("com.amazonaws.ecs.task-definition-version", ""));
                    ((Map)this.details).put("ecs-metadata", ecsDetails);
                }
            } else {
                this.log.warn((Function0)setup.1.INSTANCE);
            }
        } else {
            this.log.info((Function0)setup.2.INSTANCE);
        }
    }

    public void contribute(@NotNull Info.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.withDetails(MapsKt.toMap((Map)this.details));
    }
}

