/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.json;

import java.util.function.Consumer;
import java.util.function.Function;

public abstract class JsonField<T> {
    public abstract <D> D ifPresent(D var1, Function<T, D> var2);

    public void ifPresent(Consumer<T> callback) {
        this.ifPresent(null, v -> {
            callback.accept(v);
            return null;
        });
    }

    public static <T> JsonField<T> absent() {
        return JsonFieldAbsent.ABSENT_FIELD;
    }

    public static <T> JsonField<T> wrap(T value) {
        return new JsonFieldPresent(value);
    }

    public static class JsonFieldAbsent<T>
    extends JsonField<T> {
        static final JsonFieldAbsent<?> ABSENT_FIELD = new JsonFieldAbsent();

        @Override
        public <D> D ifPresent(D defResponse, Function<T, D> callback) {
            return defResponse;
        }

        private JsonFieldAbsent() {
        }

        public String toString() {
            return "JsonField.JsonFieldAbsent()";
        }
    }

    public static class JsonFieldPresent<T>
    extends JsonField<T> {
        private final T value;

        public T getValue() {
            return this.value;
        }

        @Override
        public <D> D ifPresent(D defResponse, Function<T, D> callback) {
            return callback.apply(this.value);
        }

        private JsonFieldPresent(T value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonFieldPresent)) {
                return false;
            }
            JsonFieldPresent other = (JsonFieldPresent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JsonFieldPresent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "JsonField.JsonFieldPresent(value=" + this.getValue() + ")";
        }
    }
}

