/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.db;

import com.ninja_squad.dbsetup.destination.Destination;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionAwareDataSourceDestination
implements Destination {
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;

    TransactionAwareDataSourceDestination(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
        this.transactionManager = transactionManager;
    }

    public Connection getConnection() {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new TransactionAwareInvocationHandler(this.dataSource));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionAwareDataSourceDestination)) {
            return false;
        }
        TransactionAwareDataSourceDestination other = (TransactionAwareDataSourceDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$dataSource = this.dataSource;
        DataSource other$dataSource = other.dataSource;
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        PlatformTransactionManager this$transactionManager = this.transactionManager;
        PlatformTransactionManager other$transactionManager = other.transactionManager;
        return !(this$transactionManager == null ? other$transactionManager != null : !this$transactionManager.equals(other$transactionManager));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionAwareDataSourceDestination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.dataSource;
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        PlatformTransactionManager $transactionManager = this.transactionManager;
        result = result * 59 + ($transactionManager == null ? 43 : $transactionManager.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionAwareDataSourceDestination(dataSource=" + this.dataSource + ", transactionManager=" + this.transactionManager + ")";
    }

    private class TransactionAwareInvocationHandler
    extends DefaultTransactionDefinition
    implements InvocationHandler {
        private final DataSource targetDataSource;

        TransactionAwareInvocationHandler(DataSource targetDataSource) {
            this.targetDataSource = targetDataSource;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "commit": {
                    TransactionStatus status = TransactionAwareDataSourceDestination.this.transactionManager.getTransaction((TransactionDefinition)this);
                    TransactionAwareDataSourceDestination.this.transactionManager.commit(status);
                    return null;
                }
                case "rollback": {
                    TransactionStatus status = TransactionAwareDataSourceDestination.this.transactionManager.getTransaction((TransactionDefinition)this);
                    TransactionAwareDataSourceDestination.this.transactionManager.rollback(status);
                    return null;
                }
            }
            try {
                Connection connection = this.targetDataSource.getConnection();
                return method.invoke((Object)connection, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

