/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.time.Duration;

public class DurationFromMillisDeserializer
extends StdScalarDeserializer<Duration> {
    public DurationFromMillisDeserializer() {
        super(Duration.class);
    }

    public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int currentToken = jsonParser.getCurrentTokenId();
        if (currentToken != 7) {
            deserializationContext.reportWrongTokenException(Duration.class, JsonToken.VALUE_NUMBER_INT, "expected integer", new Object[0]);
        }
        return Duration.ofMillis(jsonParser.getLongValue());
    }
}

