/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.exception;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.IgnoredPropertyException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import pl.sparkbit.commons.exception.BusinessException;
import pl.sparkbit.commons.exception.RestErrorAttributes;
import pl.sparkbit.commons.exception.RestErrorAttributesKt;
import pl.sparkbit.commons.i18n.Messages;

@Order(value=-2147483648)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010\u0010\u001a\u00020\t2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J&\u0010\u0013\u001a\u00020\t2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\t2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0002J(\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0006\b\u0000\u0010\u0019\u0018\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0082\b\u00a2\u0006\u0002\u0010\u001dJ&\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lpl/sparkbit/commons/exception/RestErrorAttributes;", "Lorg/springframework/boot/web/servlet/error/DefaultErrorAttributes;", "messagesOpt", "Lorg/springframework/beans/factory/ObjectProvider;", "Lpl/sparkbit/commons/i18n/Messages;", "(Lorg/springframework/beans/factory/ObjectProvider;)V", "log", "Lmu/KLogger;", "addFieldErrors", "", "attrs", "", "", "", "exc", "", "addMessagesWithDetails", "errorAttributes", "throwable", "addStatus", "result", "status", "", "addTimestamp", "getAttribute", "T", "requestAttributes", "Lorg/springframework/web/context/request/RequestAttributes;", "name", "(Lorg/springframework/web/context/request/RequestAttributes;Ljava/lang/String;)Ljava/lang/Object;", "getErrorAttributes", "", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "opts", "Lorg/springframework/boot/web/error/ErrorAttributeOptions;", "Companion", "sparkbit-commons"})
public final class RestErrorAttributes
extends DefaultErrorAttributes {
    private final KLogger log;
    private final ObjectProvider<Messages> messagesOpt;
    private static final Set<Class<?>> NOT_LOGGABLE_EXCEPTIONS;
    private static final String FIELD_ERRORS = "fieldErrors";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_ERROR_MSG = "msg";
    public static final Companion Companion;

    @NotNull
    public Map<String, Object> getErrorAttributes(@NotNull WebRequest webRequest, @NotNull ErrorAttributeOptions opts) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)webRequest, (String)"webRequest");
        Intrinsics.checkParameterIsNotNull((Object)opts, (String)"opts");
        String accept = webRequest.getHeader("accept");
        if (accept == null || MediaType.valueOf((String)accept).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            Object object;
            boolean bl = false;
            Map errorAttributes = new LinkedHashMap();
            RestErrorAttributes restErrorAttributes = this;
            String name$iv = "javax.servlet.error.status_code";
            boolean $i$f$getAttribute2 = false;
            Object object2 = ((RequestAttributes)webRequest).getAttribute(name$iv, 0);
            if (object2 == null) {
                object = null;
            } else {
                Object attr$iv = object2;
                if (!(attr$iv instanceof Integer)) {
                    throw (Throwable)new IllegalStateException("Attribute \"" + name$iv + "\" is " + attr$iv + " (" + attr$iv.getClass() + "). Expected " + Integer.class);
                }
                object = attr$iv;
            }
            Integer n = (Integer)object;
            int status = n != null ? n : 999;
            Throwable throwable = this.getError(webRequest);
            this.addTimestamp(errorAttributes);
            this.addStatus(errorAttributes, status);
            this.addMessagesWithDetails(errorAttributes, throwable);
            this.addFieldErrors(errorAttributes, throwable);
            if (throwable == null && 500 <= (name$iv = status) && 599 >= name$iv) {
                Object object3;
                RestErrorAttributes $i$f$getAttribute2 = this;
                String name$iv2 = "javax.servlet.error.message";
                boolean $i$f$getAttribute3 = false;
                Object object4 = ((RequestAttributes)webRequest).getAttribute(name$iv2, 0);
                if (object4 == null) {
                    object3 = null;
                } else {
                    Object attr$iv = object4;
                    if (!(attr$iv instanceof Object)) {
                        throw (Throwable)new IllegalStateException("Attribute \"" + name$iv2 + "\" is " + attr$iv + " (" + attr$iv.getClass() + "). Expected " + Object.class);
                    }
                    object3 = attr$iv;
                }
                Object message2 = object3;
                this.log.error((Function0)new Function0<String>(message2){
                    final /* synthetic */ Object $message;

                    @NotNull
                    public final String invoke() {
                        return "Runtime exception: " + this.$message;
                    }
                    {
                        this.$message = object;
                        super(0);
                    }
                });
            } else if (NOT_LOGGABLE_EXCEPTIONS.stream().noneMatch(new Predicate<Class<?>>(throwable){
                final /* synthetic */ Throwable $throwable;

                public final boolean test(Class<?> it) {
                    return it.isInstance(this.$throwable);
                }
                {
                    this.$throwable = throwable;
                }
            })) {
                this.log.error("Runtime exception", throwable);
            }
            map = errorAttributes;
        } else {
            Map map2 = super.getErrorAttributes(webRequest, opts);
            map = map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"super.getErrorAttributes(webRequest, opts)");
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMessagesWithDetails(Map<String, Object> errorAttributes, Throwable throwable) {
        String message2;
        String string;
        String string2;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof BusinessException) {
            errorAttributes.put("errorCode", ((BusinessException)throwable).getErrorCode());
            this.messagesOpt.ifAvailable((Consumer)new Consumer<Messages>(errorAttributes, throwable){
                final /* synthetic */ Map $errorAttributes;
                final /* synthetic */ Throwable $throwable;

                public final void accept(@NotNull Messages messages) {
                    Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
                    this.$errorAttributes.put("translatedMessage", messages.error(((BusinessException)this.$throwable).getErrorCode(), ((BusinessException)this.$throwable).getMessageDetails()));
                }
                {
                    this.$errorAttributes = map;
                    this.$throwable = throwable;
                }
            });
            Map<String, Object> additionalErrorDetails = ((BusinessException)throwable).getAdditionalErrorDetails();
            if (additionalErrorDetails != null) {
                errorAttributes.put("errorDetails", additionalErrorDetails);
            }
            string2 = throwable.getMessage();
        } else if (throwable2 instanceof MethodArgumentNotValidException) {
            void $this$mapNotNullTo$iv$iv;
            BindingResult bindingResult = ((MethodArgumentNotValidException)throwable).getBindingResult();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingResult, (String)"throwable.bindingResult");
            List list = bindingResult.getAllErrors();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"throwable.bindingResult.allErrors");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ObjectError it = (ObjectError)element$iv$iv;
                boolean bl2 = false;
                ObjectError objectError = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectError, (String)"it");
                if (objectError.getDefaultMessage() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl6 = false;
            Iterable it = $this$mapNotNull$iv;
            boolean bl7 = false;
            Collection collection = (Collection)it;
            boolean bl8 = false;
            string2 = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"\n- ", (CharSequence)"Validation errors:\n- ", null, (int)0, null, null, (int)60, null) : "Validation failed";
        } else if (throwable2 instanceof HttpMessageNotReadableException) {
            Throwable cause = throwable.getCause();
            if (cause instanceof InvalidFormatException) {
                Class clazz = ((InvalidFormatException)cause).getTargetType();
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"cause.targetType");
                if (clazz.isEnum()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid value \"").append(((InvalidFormatException)cause).getValue()).append("\". Correct values are: ");
                    Class clazz2 = ((InvalidFormatException)cause).getTargetType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"cause.targetType");
                    Object[] objectArray = clazz2.getEnumConstants();
                    Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"cause.targetType.enumConstants");
                    string2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)addMessagesWithDetails.message.4.INSTANCE, (int)31, null)).toString();
                } else {
                    string2 = "Invalid value \"" + ((InvalidFormatException)cause).getValue() + '\"';
                }
            } else if (cause instanceof UnrecognizedPropertyException) {
                string2 = "Unrecognized property \"" + ((UnrecognizedPropertyException)cause).getPropertyName() + '\"';
            } else if (cause instanceof IgnoredPropertyException) {
                string2 = "Invalid property \"" + ((IgnoredPropertyException)cause).getPropertyName() + '\"';
            } else if (cause instanceof InvalidTypeIdException) {
                string2 = "Invalid object type \"" + ((InvalidTypeIdException)cause).getTypeId() + '\"';
            } else if (cause instanceof MismatchedInputException) {
                string2 = "Invalid JSON payload";
            } else if (cause instanceof JsonParseException) {
                string2 = "JSON payload is not well formatted";
            } else if (cause instanceof JsonMappingException) {
                if (((JsonMappingException)cause).getPath().isEmpty()) {
                    string2 = null;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid value in field \"");
                    List list = ((JsonMappingException)cause).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cause.path");
                    string2 = stringBuilder.append(RestErrorAttributesKt.access$asStr(list)).append('\"').toString();
                }
            } else {
                string2 = null;
            }
        } else {
            string2 = null;
        }
        if ((string = (message2 = string2)) == null) {
            string = "Unknown error";
        }
        errorAttributes.put("message", string);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFieldErrors(Map<String, Object> attrs, Throwable exc) {
        block6: {
            Throwable cause;
            block8: {
                block7: {
                    String string;
                    Throwable throwable;
                    block5: {
                        Collection<Map> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        if (exc == null) {
                            return;
                        }
                        throwable = exc;
                        if (!(throwable instanceof MethodArgumentNotValidException)) break block5;
                        BindingResult bindingResult = ((MethodArgumentNotValidException)exc).getBindingResult();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingResult, (String)"exc.bindingResult");
                        List list = bindingResult.getFieldErrors();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"exc.bindingResult.fieldErrors");
                        Iterable iterable = list;
                        String string2 = FIELD_ERRORS;
                        Map<String, Object> map = attrs;
                        boolean $i$f$map = false;
                        void var6_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FieldError fieldError = (FieldError)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Pair[] pairArray = new Pair[2];
                            void v3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                            pairArray[0] = TuplesKt.to((Object)FIELD_PATH, (Object)v3.getField());
                            pairArray[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)it.getDefaultMessage());
                            Map map2 = MapsKt.mapOf((Pair[])pairArray);
                            collection.add(map2);
                        }
                        collection = (List)destination$iv$iv;
                        map.put(string2, collection);
                        break block6;
                    }
                    if (!(throwable instanceof HttpMessageNotReadableException)) break block6;
                    cause = exc.getCause();
                    if (!(cause instanceof InvalidFormatException)) break block7;
                    Class clazz = ((InvalidFormatException)cause).getTargetType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"cause.targetType");
                    if (clazz.isEnum()) {
                        StringBuilder stringBuilder = new StringBuilder().append("invalid value \"").append(((InvalidFormatException)cause).getValue()).append("\", valid are: ");
                        Class clazz2 = ((InvalidFormatException)cause).getTargetType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"cause.targetType");
                        Object[] objectArray = clazz2.getEnumConstants();
                        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"cause.targetType.enumConstants");
                        string = stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)addFieldErrors.msg.1.INSTANCE, (int)31, null)).toString();
                    } else {
                        string = "invalid value \"" + ((InvalidFormatException)cause).getValue() + '\"';
                    }
                    String msg2 = string;
                    List list = ((InvalidFormatException)cause).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cause.path");
                    Collection collection = list;
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break block6;
                    Pair[] pairArray = new Pair[2];
                    List list2 = ((InvalidFormatException)cause).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"cause.path");
                    pairArray[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list2));
                    pairArray[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)msg2);
                    attrs.put(FIELD_ERRORS, CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
                    break block6;
                }
                if (!(cause instanceof UnrecognizedPropertyException)) break block8;
                List list = ((UnrecognizedPropertyException)cause).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cause.path");
                Collection collection = list;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block6;
                Pair[] pairArray = new Pair[2];
                List list3 = ((UnrecognizedPropertyException)cause).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"cause.path");
                pairArray[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list3));
                pairArray[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)"unrecognized property");
                attrs.put(FIELD_ERRORS, CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
                break block6;
            }
            if (!(cause instanceof JsonMappingException)) break block6;
            List list = ((JsonMappingException)cause).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cause.path");
            Collection collection = list;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Pair[] pairArray = new Pair[2];
                List list4 = ((JsonMappingException)cause).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"cause.path");
                pairArray[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list4));
                pairArray[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)"invalid");
                attrs.put(FIELD_ERRORS, CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
            }
        }
    }

    private final void addTimestamp(Map<String, Object> result) {
        result.put("timestamp", Instant.now().toEpochMilli());
    }

    private final void addStatus(Map<String, Object> result, int status) {
        result.put("status", status);
    }

    private final /* synthetic */ <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        int $i$f$getAttribute = 0;
        Object object = requestAttributes.getAttribute(name, 0);
        if (object == null) {
            return null;
        }
        Object attr = object;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!(attr instanceof Object)) {
            StringBuilder stringBuilder = new StringBuilder().append("Attribute \"").append(name).append("\" is ").append(attr).append(" (").append(attr.getClass()).append("). Expected ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new IllegalStateException(stringBuilder.append(Object.class).toString());
        }
        return (T)attr;
    }

    public RestErrorAttributes(@NotNull ObjectProvider<Messages> messagesOpt) {
        Intrinsics.checkParameterIsNotNull(messagesOpt, (String)"messagesOpt");
        this.messagesOpt = messagesOpt;
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        NOT_LOGGABLE_EXCEPTIONS = SetsKt.setOf((Object[])new Class[]{TypeMismatchException.class, MethodArgumentNotValidException.class, AccessDeniedException.class});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/sparkbit/commons/exception/RestErrorAttributes$Companion;", "", "()V", "FIELD_ERRORS", "", "FIELD_ERROR_MSG", "FIELD_PATH", "NOT_LOGGABLE_EXCEPTIONS", "", "Ljava/lang/Class;", "sparkbit-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

