/*
 * Decompiled with CFR 0.152.
 */
package pl.rzrz.kotlin.test.factories.core;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import pl.rzrz.kotlin.test.factories.core.TestFactoryException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u0002H\b\"\u0006\b\u0000\u0010\b\u0018\u0001H\u0086\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0007\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J(\u0010\r\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fH\u0002J\u0014\u0010\r\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00012\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006J\u0012\u0010\u001a\u001a\u00020\u00182\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005R$\u0010\u0003\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/rzrz/kotlin/test/factories/core/ObjectCreator;", "", "()V", "customFactoryByClass", "", "Lkotlin/reflect/KClass;", "Lkotlin/Function0;", "create", "T", "()Ljava/lang/Object;", "kClass", "kType", "Lkotlin/reflect/KType;", "createObject", "constructors", "", "Lkotlin/reflect/KFunction;", "constructor", "createWithCustomFactory", "getEnumValue", "jClass", "Ljava/lang/Class;", "matchAndCreate", "register", "", "customFactory", "unregister", "kotlin-test-factories_core"})
public final class ObjectCreator {
    private static final Map<KClass<?>, Function0<Object>> customFactoryByClass;
    @NotNull
    public static final ObjectCreator INSTANCE;

    public final /* synthetic */ <T> T create() {
        int $i$f$create = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        Object object = this.create(kClass, null);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    private final Object create(KType kType) {
        KClassifier kClassifier = kType.getClassifier();
        if (kClassifier == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        }
        return this.create((KClass)kClassifier, kType);
    }

    @NotNull
    public final Object create(@NotNull KClass<?> kClass, @NotNull KType kType) {
        Object object;
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        Object customFactoryResult = this.createWithCustomFactory(kClass);
        if (customFactoryResult != null) {
            return customFactoryResult;
        }
        try {
            object = this.matchAndCreate(kClass, kType);
        }
        catch (Exception e) {
            throw (Throwable)new TestFactoryException("Error creating " + kClass.getSimpleName(), e);
        }
        return object;
    }

    private final Object createWithCustomFactory(KClass<?> kClass) {
        Function0<Object> function0 = customFactoryByClass.get(kClass);
        if (function0 == null) {
            return null;
        }
        Function0<Object> factory = function0;
        return factory.invoke();
    }

    private final Object matchAndCreate(KClass<?> kClass, KType kType) {
        Object object;
        Class jClass = JvmClassMappingKt.getJavaClass(kClass);
        if (jClass.isEnum()) {
            return this.getEnumValue(jClass);
        }
        KClass<?> kClass2 = kClass;
        if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            object = bigDecimal;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.ZERO");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            object = Character.valueOf(' ');
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = 0.0;
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Duration.class))) {
            Duration duration = Duration.ZERO;
            object = duration;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(0.0f);
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            Instant instant = Instant.now();
            object = instant;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.now()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = 0;
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(List.class))) {
            KType kType2 = ((KTypeProjection)kType.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kType2);
            object = CollectionsKt.listOf((Object)this.create(kType2));
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(LocalTime.class))) {
            LocalTime localTime = LocalTime.now();
            object = localTime;
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"LocalTime.now()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            LocalDate localDate = LocalDate.now();
            object = localDate;
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.now()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
            LocalDateTime localDateTime = LocalDateTime.now();
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.now()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = 0L;
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(Map.class))) {
            KType kType3 = ((KTypeProjection)kType.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kType3);
            Object object2 = this.create(kType3);
            KType kType4 = ((KTypeProjection)kType.getArguments().get(1)).getType();
            Intrinsics.checkNotNull((Object)kType4);
            object = MapsKt.mapOf((Pair)TuplesKt.to((Object)object2, (Object)this.create(kType4)));
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = "";
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(ZonedDateTime.class))) {
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            object = zonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(UUID.class))) {
            UUID uUID = UUID.randomUUID();
            object = uUID;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        } else if (Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(URI.class))) {
            URI uRI = URI.create("https://example.com");
            object = uRI;
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI.create(\"https://example.com\")");
        } else {
            object = Intrinsics.areEqual(kClass2, (Object)Reflection.getOrCreateKotlinClass(URL.class)) ? new URL("https://example.com") : this.createObject(kClass);
        }
        return object;
    }

    private final Object getEnumValue(Class<? extends Object> jClass) {
        Object[] objectArray = jClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"jClass.enumConstants");
        Object object = ArraysKt.first((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jClass.enumConstants.first()");
        return object;
    }

    private final Object createObject(KClass<?> kClass, List<? extends KFunction<? extends Object>> constructors) {
        Object object;
        KFunction kFunction = (KFunction)CollectionsKt.firstOrNull(constructors);
        if (kFunction == null) {
            throw (Throwable)new TestFactoryException("No suitable constructors: " + kClass.getSimpleName(), null, 2, null);
        }
        KFunction constructor = kFunction;
        try {
            object = this.createObject(constructor);
        }
        catch (Exception e) {
            object = this.createObject(kClass, CollectionsKt.drop((Iterable)constructors, (int)1));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Object createObject(KClass<?> kClass) {
        void $this$filterTo$iv$iv;
        if (kClass.isSealed()) {
            return this.createObject((KClass)CollectionsKt.first((List)kClass.getSealedSubclasses()));
        }
        Iterable $this$filter$iv = kClass.getConstructors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KFunction it = (KFunction)element$iv$iv;
            boolean bl = false;
            if (!(it.getVisibility() == KVisibility.PUBLIC)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        List constructors = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                KFunction it = (KFunction)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getParameters().size());
                it = (KFunction)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getParameters().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        return this.createObject(kClass, constructors);
    }

    /*
     * WARNING - void declaration
     */
    private final Object createObject(KFunction<?> constructor) {
        Object object;
        KType parameter;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = constructor.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KParameter kParameter = (KParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = parameter.getType();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameterType;
            parameter = (KType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = INSTANCE.create((KType)parameterType);
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] arguments = objectArray;
        Object object2 = constructor.call(Arrays.copyOf(arguments, arguments.length));
        Intrinsics.checkNotNull((Object)object2);
        return object2;
    }

    public final <T> void register(@NotNull KClass<T> kClass, @NotNull Function0<? extends T> customFactory) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter(customFactory, (String)"customFactory");
        customFactoryByClass.put(kClass, customFactory);
    }

    public final void unregister(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        customFactoryByClass.remove(kClass);
    }

    private ObjectCreator() {
    }

    static {
        ObjectCreator objectCreator;
        INSTANCE = objectCreator = new ObjectCreator();
        boolean bl = false;
        customFactoryByClass = new LinkedHashMap();
    }
}

