/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.math3.stat.StatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import pl.poznan.put.utility.ImmutableExecHelper;
import pl.poznan.put.utility.svg.Format;

public final class SVGHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVGHelper.class);
    private static final NamespaceContext SVG_NAMESPACE = new SVGNamespace();
    private static final DOMImplementation DOM_IMPLEMENTATION = SVGDOMImplementation.getDOMImplementation();

    private SVGHelper() {
    }

    public static SVGDocument fromFile(File file) throws IOException {
        return SVGHelper.fromUri(file.toURI());
    }

    public static SVGDocument fromUri(URI uri) throws IOException {
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        return (SVGDocument)factory.createDocument(uri.toString());
    }

    public static LineMetrics getLineMetrics(SVGGraphics2D svg) {
        FontRenderContext renderContext = svg.getFontRenderContext();
        Font font = svg.getFont();
        return font.getLineMetrics("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", renderContext);
    }

    public static NamespaceContext svgNamespaceContext() {
        return SVG_NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] export(SVGDocument svgDocument, Format format) throws IOException {
        byte[] byArray;
        if (format == Format.SVG) {
            return SVGHelper.exportInternal(svgDocument, Format.SVG);
        }
        File inputFile = null;
        File outputFile = null;
        try {
            inputFile = File.createTempFile("svg-helper", ".svg");
            FileUtils.writeByteArrayToFile((File)inputFile, (byte[])SVGHelper.export(svgDocument, Format.SVG));
            outputFile = File.createTempFile("svg-helper", '.' + format.getExtension());
            ImmutableExecHelper.builder().command("inkscape").addArguments("--without-gui", format.getInkscapeArgument(), outputFile.getAbsolutePath(), inputFile.getAbsolutePath()).build().execute();
            byArray = FileUtils.readFileToByteArray((File)outputFile);
            FileUtils.deleteQuietly((File)inputFile);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to run inkscape to export image, will try to use Apache FOP", (Throwable)e);
            byte[] byArray2 = SVGHelper.exportInternal(svgDocument, format);
            return byArray2;
        }
        finally {
            FileUtils.deleteQuietly((File)inputFile);
            FileUtils.deleteQuietly(outputFile);
        }
        FileUtils.deleteQuietly((File)outputFile);
        return byArray;
    }

    public static SVGDocument merge(List<SVGDocument> svgs) {
        if (svgs.isEmpty()) {
            return SVGHelper.emptyDocument();
        }
        Rectangle2D[] boxes = new Rectangle2D[svgs.size()];
        boolean[] isValid = new boolean[svgs.size()];
        int size = svgs.size();
        for (int i = 0; i < size; ++i) {
            SVGDocument svg = svgs.get(i);
            try {
                boxes[i] = SVGHelper.calculateBoundingBox((Document)svg);
                isValid[i] = true;
            }
            catch (BridgeException bridgeException) {
                // empty catch block
            }
            if (boxes[i] != null) continue;
            boxes[i] = new Rectangle2D.Double();
            isValid[i] = false;
        }
        SVGDocument mergedSvg = svgs.get(0);
        SVGSVGElement mergedRoot = mergedSvg.getRootElement();
        double[] widths = new double[svgs.size()];
        double[] heights = new double[svgs.size()];
        double currentWidth = 0.0;
        for (int i = 0; i < svgs.size(); ++i) {
            SVGDocument svg = svgs.get(i);
            if (!isValid[i]) continue;
            Rectangle2D box = boxes[i];
            widths[i] = box.getWidth() + box.getX();
            heights[i] = box.getHeight() + box.getY();
            SVGSVGElement rootElement = svg.getRootElement();
            rootElement.setAttribute("x", Double.toString(currentWidth));
            currentWidth += widths[i];
            if (i <= 0) continue;
            Node importedNode = mergedSvg.importNode((Node)svg.getDocumentElement(), true);
            mergedRoot.appendChild(importedNode);
        }
        double mergedWidth = StatUtils.sum((double[])widths);
        double mergedHeight = StatUtils.max((double[])heights);
        mergedRoot.setAttribute("width", Double.toString(mergedWidth));
        mergedRoot.setAttribute("height", Double.toString(mergedHeight));
        mergedRoot.setAttribute("viewBox", String.format("0 0 %s %s", mergedWidth, mergedHeight));
        return mergedSvg;
    }

    public static SVGDocument emptyDocument() {
        return (SVGDocument)DOM_IMPLEMENTATION.createDocument("http://www.w3.org/2000/svg", "svg", null);
    }

    public static Rectangle2D calculateBoundingBox(Document doc) {
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext((UserAgent)new UserAgentAdapter());
        GraphicsNode gvtRoot = builder.build(ctx, doc);
        return gvtRoot.getSensitiveBounds();
    }

    public static double getWidth(SVGDocument document) {
        SVGSVGElement rootElement = document.getRootElement();
        String attribute = rootElement.getAttribute("width");
        return Double.parseDouble(attribute);
    }

    public static double getHeight(SVGDocument document) {
        SVGSVGElement rootElement = document.getRootElement();
        String attribute = rootElement.getAttribute("height");
        return Double.parseDouble(attribute);
    }

    private static byte[] exportInternal(SVGDocument svgDocument, Format format) throws IOException {
        return SVGHelper.exportInternal(svgDocument, format, Collections.emptyMap());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] exportInternal(SVGDocument svgDocument, Format format, Map<TranscodingHints.Key, Object> transcodingHints) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, Charset.defaultCharset());){
                Transcoder transcoder = format.getTranscoder();
                for (Map.Entry<TranscodingHints.Key, Object> entry : transcodingHints.entrySet()) {
                    transcoder.addTranscodingHint(entry.getKey(), entry.getValue());
                }
                TranscoderInput input = new TranscoderInput((Document)svgDocument);
                TranscoderOutput output = format == Format.SVG ? new TranscoderOutput((Writer)writer) : new TranscoderOutput((OutputStream)stream);
                transcoder.transcode(input, output);
                byArray = stream.toByteArray();
            }
            return byArray;
        }
        catch (TranscoderException e) {
            throw new IOException("Failed to save SVG as image", e);
        }
    }

    private static class SVGNamespace
    implements NamespaceContext {
        private SVGNamespace() {
        }

        @Override
        public final String getNamespaceURI(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Null prefix for namespace");
            }
            if (Objects.equals("svg", s)) {
                return "http://www.w3.org/2000/svg";
            }
            return "";
        }

        @Override
        public final String getPrefix(String s) {
            throw new UnsupportedOperationException("N/A");
        }

        @Override
        public final Iterator<String> getPrefixes(String s) {
            throw new UnsupportedOperationException("N/A");
        }
    }
}

