/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public final class ResourcesHelper {
    private ResourcesHelper() {
    }

    public static String loadResource(String resource) throws IOException {
        ClassLoader loader = ResourcesHelper.class.getClassLoader();
        try (InputStream stream = loader.getResourceAsStream(resource);){
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Missing resource: %s", resource));
            }
            String string = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    public static File loadResourceFile(String resource) throws URISyntaxException {
        return new File(ResourcesHelper.loadResourceUri(resource));
    }

    public static URI loadResourceUri(String resource) throws URISyntaxException {
        ClassLoader loader = ResourcesHelper.class.getClassLoader();
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException(String.format("Missing resource: %s", resource));
        }
        return url.toURI();
    }
}

