/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.utility.ExecHelper;

@ParametersAreNonnullByDefault
@Generated(from="ExecHelper.ExecutionResult", generator="Immutables")
@Immutable
public final class ImmutableExecutionResult
implements ExecHelper.ExecutionResult {
    private final int exitCode;
    private final String standardOutput;
    private final String standardError;

    private ImmutableExecutionResult(int exitCode, String standardOutput, String standardError) {
        this.exitCode = exitCode;
        this.standardOutput = Objects.requireNonNull(standardOutput, "standardOutput");
        this.standardError = Objects.requireNonNull(standardError, "standardError");
    }

    private ImmutableExecutionResult(ImmutableExecutionResult original, int exitCode, String standardOutput, String standardError) {
        this.exitCode = exitCode;
        this.standardOutput = standardOutput;
        this.standardError = standardError;
    }

    @Override
    public int exitCode() {
        return this.exitCode;
    }

    @Override
    public String standardOutput() {
        return this.standardOutput;
    }

    @Override
    public String standardError() {
        return this.standardError;
    }

    public final ImmutableExecutionResult withExitCode(int value) {
        if (this.exitCode == value) {
            return this;
        }
        return new ImmutableExecutionResult(this, value, this.standardOutput, this.standardError);
    }

    public final ImmutableExecutionResult withStandardOutput(String value) {
        String newValue = Objects.requireNonNull(value, "standardOutput");
        if (this.standardOutput.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionResult(this, this.exitCode, newValue, this.standardError);
    }

    public final ImmutableExecutionResult withStandardError(String value) {
        String newValue = Objects.requireNonNull(value, "standardError");
        if (this.standardError.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionResult(this, this.exitCode, this.standardOutput, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutionResult && this.equalTo((ImmutableExecutionResult)another);
    }

    private boolean equalTo(ImmutableExecutionResult another) {
        return this.exitCode == another.exitCode && this.standardOutput.equals(another.standardOutput) && this.standardError.equals(another.standardError);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.exitCode;
        h += (h << 5) + this.standardOutput.hashCode();
        h += (h << 5) + this.standardError.hashCode();
        return h;
    }

    public String toString() {
        return "ExecutionResult{exitCode=" + this.exitCode + ", standardOutput=" + this.standardOutput + ", standardError=" + this.standardError + "}";
    }

    public static ImmutableExecutionResult of(int exitCode, String standardOutput, String standardError) {
        return new ImmutableExecutionResult(exitCode, standardOutput, standardError);
    }

    public static ImmutableExecutionResult copyOf(ExecHelper.ExecutionResult instance) {
        if (instance instanceof ImmutableExecutionResult) {
            return (ImmutableExecutionResult)instance;
        }
        return ImmutableExecutionResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecHelper.ExecutionResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXIT_CODE = 1L;
        private static final long INIT_BIT_STANDARD_OUTPUT = 2L;
        private static final long INIT_BIT_STANDARD_ERROR = 4L;
        private long initBits = 7L;
        private int exitCode;
        @Nullable
        private String standardOutput;
        @Nullable
        private String standardError;

        private Builder() {
        }

        public final Builder from(ExecHelper.ExecutionResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.exitCode(instance.exitCode());
            this.standardOutput(instance.standardOutput());
            this.standardError(instance.standardError());
            return this;
        }

        public final Builder exitCode(int exitCode) {
            this.exitCode = exitCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder standardOutput(String standardOutput) {
            this.standardOutput = Objects.requireNonNull(standardOutput, "standardOutput");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder standardError(String standardError) {
            this.standardError = Objects.requireNonNull(standardError, "standardError");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableExecutionResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutionResult(null, this.exitCode, this.standardOutput, this.standardError);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exitCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("standardOutput");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("standardError");
            }
            return "Cannot build ExecutionResult, some of required attributes are not set " + attributes;
        }
    }
}

