/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.utility.ExecHelper;

@ParametersAreNonnullByDefault
@Generated(from="ExecHelper", generator="Immutables")
@Immutable
public final class ImmutableExecHelper
extends ExecHelper {
    @Nullable
    private final File workingDirectory;
    private final String command;
    private final Map<String, String> environment;
    private final List<String> arguments;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExecHelper(Builder builder) {
        this.workingDirectory = builder.workingDirectory;
        this.command = builder.command;
        if (builder.environmentIsSet()) {
            this.initShim.environment(ImmutableExecHelper.createUnmodifiableMap(false, false, builder.environment));
        }
        if (builder.argumentsIsSet()) {
            this.initShim.arguments(ImmutableExecHelper.createUnmodifiableList(true, builder.arguments));
        }
        this.environment = this.initShim.environment();
        this.arguments = this.initShim.arguments();
        this.initShim = null;
    }

    private ImmutableExecHelper(@Nullable File workingDirectory, String command, Map<String, String> environment, List<String> arguments) {
        this.workingDirectory = workingDirectory;
        this.command = command;
        this.environment = environment;
        this.arguments = arguments;
        this.initShim = null;
    }

    @Override
    public Optional<File> workingDirectory() {
        return Optional.ofNullable(this.workingDirectory);
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public Map<String, String> environment() {
        InitShim shim = this.initShim;
        return shim != null ? shim.environment() : this.environment;
    }

    @Override
    public List<String> arguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.arguments() : this.arguments;
    }

    public final ImmutableExecHelper withWorkingDirectory(File value) {
        File newValue = Objects.requireNonNull(value, "workingDirectory");
        if (this.workingDirectory == newValue) {
            return this;
        }
        return new ImmutableExecHelper(newValue, this.command, this.environment, this.arguments);
    }

    public final ImmutableExecHelper withWorkingDirectory(Optional<? extends File> optional) {
        File value = optional.orElse(null);
        if (this.workingDirectory == value) {
            return this;
        }
        return new ImmutableExecHelper(value, this.command, this.environment, this.arguments);
    }

    public final ImmutableExecHelper withCommand(String value) {
        String newValue = Objects.requireNonNull(value, "command");
        if (this.command.equals(newValue)) {
            return this;
        }
        return new ImmutableExecHelper(this.workingDirectory, newValue, this.environment, this.arguments);
    }

    public final ImmutableExecHelper withEnvironment(Map<String, ? extends String> entries) {
        if (this.environment == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableExecHelper.createUnmodifiableMap(true, false, entries);
        return new ImmutableExecHelper(this.workingDirectory, this.command, newValue, this.arguments);
    }

    public final ImmutableExecHelper withArguments(String ... elements) {
        List<String> newValue = ImmutableExecHelper.createUnmodifiableList(false, ImmutableExecHelper.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExecHelper(this.workingDirectory, this.command, this.environment, newValue);
    }

    public final ImmutableExecHelper withArguments(Iterable<String> elements) {
        if (this.arguments == elements) {
            return this;
        }
        List<String> newValue = ImmutableExecHelper.createUnmodifiableList(false, ImmutableExecHelper.createSafeList(elements, true, false));
        return new ImmutableExecHelper(this.workingDirectory, this.command, this.environment, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecHelper && this.equalTo((ImmutableExecHelper)another);
    }

    private boolean equalTo(ImmutableExecHelper another) {
        return Objects.equals(this.workingDirectory, another.workingDirectory) && this.command.equals(another.command) && this.environment.equals(another.environment) && this.arguments.equals(another.arguments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.workingDirectory);
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.environment.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExecHelper{");
        if (this.workingDirectory != null) {
            builder.append("workingDirectory=").append(this.workingDirectory);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("command=").append(this.command);
        builder.append(", ");
        builder.append("environment=").append(this.environment);
        builder.append(", ");
        builder.append("arguments=").append(this.arguments);
        return builder.append("}").toString();
    }

    public static ImmutableExecHelper copyOf(ExecHelper instance) {
        if (instance instanceof ImmutableExecHelper) {
            return (ImmutableExecHelper)instance;
        }
        return ImmutableExecHelper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ExecHelper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMAND = 1L;
        private static final long OPT_BIT_ENVIRONMENT = 1L;
        private static final long OPT_BIT_ARGUMENTS = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private File workingDirectory;
        @Nullable
        private String command;
        private Map<String, String> environment = new LinkedHashMap<String, String>();
        private List<String> arguments = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ExecHelper instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<File> workingDirectoryOptional = instance.workingDirectory();
            if (workingDirectoryOptional.isPresent()) {
                this.workingDirectory(workingDirectoryOptional);
            }
            this.command(instance.command());
            this.putAllEnvironment(instance.environment());
            this.addAllArguments(instance.arguments());
            return this;
        }

        public final Builder workingDirectory(File workingDirectory) {
            this.workingDirectory = Objects.requireNonNull(workingDirectory, "workingDirectory");
            return this;
        }

        public final Builder workingDirectory(Optional<? extends File> workingDirectory) {
            this.workingDirectory = workingDirectory.orElse(null);
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putEnvironment(String key, String value) {
            this.environment.put(Objects.requireNonNull(key, "environment key"), Objects.requireNonNull(value, "environment value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder putEnvironment(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.environment.put(Objects.requireNonNull(k, "environment key"), Objects.requireNonNull(v, "environment value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder environment(Map<String, ? extends String> entries) {
            this.environment.clear();
            this.optBits |= 1L;
            return this.putAllEnvironment(entries);
        }

        public final Builder putAllEnvironment(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.environment.put(Objects.requireNonNull(k, "environment key"), Objects.requireNonNull(v, "environment value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addArguments(String element) {
            this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addArguments(String ... elements) {
            for (String element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder arguments(Iterable<String> elements) {
            this.arguments.clear();
            return this.addAllArguments(elements);
        }

        public final Builder addAllArguments(Iterable<String> elements) {
            for (String element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableExecHelper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecHelper(this);
        }

        private boolean environmentIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean argumentsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build ExecHelper, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ExecHelper", generator="Immutables")
    private final class InitShim {
        private byte environmentBuildStage = 0;
        private Map<String, String> environment;
        private byte argumentsBuildStage = 0;
        private List<String> arguments;

        private InitShim() {
        }

        Map<String, String> environment() {
            if (this.environmentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.environmentBuildStage == 0) {
                this.environmentBuildStage = (byte)-1;
                this.environment = ImmutableExecHelper.createUnmodifiableMap(true, false, ImmutableExecHelper.super.environment());
                this.environmentBuildStage = 1;
            }
            return this.environment;
        }

        void environment(Map<String, String> environment) {
            this.environment = environment;
            this.environmentBuildStage = 1;
        }

        List<String> arguments() {
            if (this.argumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argumentsBuildStage == 0) {
                this.argumentsBuildStage = (byte)-1;
                this.arguments = ImmutableExecHelper.createUnmodifiableList(false, ImmutableExecHelper.createSafeList(ImmutableExecHelper.super.arguments(), true, false));
                this.argumentsBuildStage = 1;
            }
            return this.arguments;
        }

        void arguments(List<String> arguments) {
            this.arguments = arguments;
            this.argumentsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.environmentBuildStage == -1) {
                attributes.add("environment");
            }
            if (this.argumentsBuildStage == -1) {
                attributes.add("arguments");
            }
            return "Cannot build ExecHelper, attribute initializers form cycle " + attributes;
        }
    }
}

