/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.utility.ImmutableExecutionResult;

@Value.Immutable
public abstract class ExecHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecHelper.class);

    public static File createRandomDirectory() throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        String randomComponent = UUID.randomUUID().toString();
        File randomDirectory = new File(tempDirectory, randomComponent);
        FileUtils.forceMkdir((File)randomDirectory);
        return randomDirectory;
    }

    private static void makeExecutable(String path) {
        File file = new File(path);
        if (!file.canExecute()) {
            file.setExecutable(true);
        }
    }

    public abstract Optional<File> workingDirectory();

    public abstract String command();

    public ExecutionResult execute() throws IOException {
        ExecHelper.makeExecutable(this.command());
        CommandLine commandLine = new CommandLine(this.command());
        for (String argument : this.arguments()) {
            commandLine.addArgument(argument);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        if (this.workingDirectory().isPresent()) {
            executor.setWorkingDirectory(this.workingDirectory().get());
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                if (this.workingDirectory().isPresent()) {
                    LOGGER.info("Running {} with arguments {} in {}", new Object[]{this.command(), this.arguments(), this.workingDirectory()});
                } else {
                    LOGGER.info("Running {} with arguments {} in", (Object)this.command(), this.arguments());
                }
            }
            int exitCode = executor.execute(commandLine, this.environment());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Standard output: {}", (Object)out);
                LOGGER.trace("Standard error: {}", (Object)err);
            }
            return ImmutableExecutionResult.of(exitCode, out.toString(Charset.defaultCharset()), err.toString(Charset.defaultCharset()));
        }
        catch (IOException e) {
            LOGGER.warn("Standard output: {}", (Object)out);
            LOGGER.warn("Standard error: {}", (Object)err);
            throw e;
        }
    }

    @Value.Default
    public Map<String, String> environment() {
        return Collections.emptyMap();
    }

    @Value.Default
    public List<String> arguments() {
        return Collections.emptyList();
    }

    @Value.Immutable
    public static interface ExecutionResult {
        @Value.Parameter(order=1)
        public int exitCode();

        @Value.Parameter(order=2)
        public String standardOutput();

        @Value.Parameter(order=3)
        public String standardError();
    }
}

