/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.utility;

import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import pl.poznan.put.utility.NumberFormatUtils;

public final class AngleFormat {
    private AngleFormat() {
    }

    public static String degreesRoundedToOne(double radians) {
        if (Double.isNaN(radians)) {
            return "NaN";
        }
        if (Double.isInfinite(radians)) {
            return "\u221e";
        }
        if (Precision.equals((double)radians, (double)0.0)) {
            return "0";
        }
        double degrees = FastMath.toDegrees((double)radians);
        long rounded = FastMath.round((double)degrees);
        return rounded + "\u00b0";
    }

    public static String degreesRoundedToHundredth(double radians) {
        if (Double.isNaN(radians)) {
            return "NaN";
        }
        if (Double.isInfinite(radians)) {
            return "\u221e";
        }
        if (Precision.equals((double)radians, (double)0.0)) {
            return "0";
        }
        double degrees = FastMath.toDegrees((double)radians);
        return NumberFormatUtils.threeDecimalDigits().format(degrees) + "\u00b0";
    }

    public static String degrees(double radians) {
        double degrees = FastMath.toDegrees((double)radians);
        return Double.toString(degrees);
    }
}

