/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.types.DistanceMatrix;

@ParametersAreNonnullByDefault
@Generated(from="DistanceMatrix", generator="Immutables")
@Immutable
public final class ImmutableDistanceMatrix
implements DistanceMatrix {
    private final List<String> names;
    private final double[][] matrix;

    private ImmutableDistanceMatrix(Iterable<String> names, double[][] matrix) {
        this.names = ImmutableDistanceMatrix.createUnmodifiableList(false, ImmutableDistanceMatrix.createSafeList(names, true, false));
        this.matrix = (double[][])matrix.clone();
    }

    private ImmutableDistanceMatrix(ImmutableDistanceMatrix original, List<String> names, double[][] matrix) {
        this.names = names;
        this.matrix = matrix;
    }

    @Override
    public List<String> names() {
        return this.names;
    }

    @Override
    public double[][] matrix() {
        return (double[][])this.matrix.clone();
    }

    public final ImmutableDistanceMatrix withNames(String ... elements) {
        List<String> newValue = ImmutableDistanceMatrix.createUnmodifiableList(false, ImmutableDistanceMatrix.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDistanceMatrix(this, newValue, this.matrix);
    }

    public final ImmutableDistanceMatrix withNames(Iterable<String> elements) {
        if (this.names == elements) {
            return this;
        }
        List<String> newValue = ImmutableDistanceMatrix.createUnmodifiableList(false, ImmutableDistanceMatrix.createSafeList(elements, true, false));
        return new ImmutableDistanceMatrix(this, newValue, this.matrix);
    }

    public final ImmutableDistanceMatrix withMatrix(double[] ... elements) {
        double[][] newValue = (double[][])elements.clone();
        return new ImmutableDistanceMatrix(this, this.names, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDistanceMatrix && this.equalTo((ImmutableDistanceMatrix)another);
    }

    private boolean equalTo(ImmutableDistanceMatrix another) {
        return this.names.equals(another.names) && Arrays.equals((Object[])this.matrix, (Object[])another.matrix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + Arrays.hashCode((Object[])this.matrix);
        return h;
    }

    public String toString() {
        return "DistanceMatrix{names=" + this.names + ", matrix=" + Arrays.toString((Object[])this.matrix) + "}";
    }

    public static ImmutableDistanceMatrix of(List<String> names, double[][] matrix) {
        return ImmutableDistanceMatrix.of(names, matrix);
    }

    public static ImmutableDistanceMatrix of(Iterable<String> names, double[][] matrix) {
        return new ImmutableDistanceMatrix(names, matrix);
    }

    public static ImmutableDistanceMatrix copyOf(DistanceMatrix instance) {
        if (instance instanceof ImmutableDistanceMatrix) {
            return (ImmutableDistanceMatrix)instance;
        }
        return ImmutableDistanceMatrix.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DistanceMatrix", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MATRIX = 1L;
        private long initBits = 1L;
        private List<String> names = new ArrayList<String>();
        @Nullable
        private double[][] matrix;

        private Builder() {
        }

        public final Builder from(DistanceMatrix instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllNames(instance.names());
            this.matrix(instance.matrix());
            return this;
        }

        public final Builder addNames(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder addNames(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder matrix(double[] ... matrix) {
            this.matrix = (double[][])matrix.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDistanceMatrix build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDistanceMatrix(null, ImmutableDistanceMatrix.createUnmodifiableList(true, this.names), this.matrix);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("matrix");
            }
            return "Cannot build DistanceMatrix, some of required attributes are not set " + attributes;
        }
    }
}

