/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion.range;

import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.RangeDifference;
import pl.poznan.put.torsion.range.RangeProvider;

public enum TorsionRange implements Range
{
    SYN_CIS("sp", -30.0, 30.0),
    ANTI_TRANS("ap", 150.0, -150.0),
    SYNCLINAL_GAUCHE_PLUS("+sc", 30.0, 90.0),
    SYNCLINAL_GAUCHE_MINUS("-sc", -90.0, -30.0),
    ANTICLINAL_PLUS("+ac", 90.0, 150.0),
    ANTICLINAL_MINUS("-ac", -150.0, -90.0),
    INVALID("invalid", Double.NaN, Double.NaN);

    private final String displayName;
    private final Angle begin;
    private final Angle end;

    private TorsionRange(String displayName, double begin, double end) {
        this.displayName = displayName;
        this.begin = ImmutableAngle.of(FastMath.toRadians((double)begin));
        this.end = ImmutableAngle.of(FastMath.toRadians((double)end));
    }

    public static RangeProvider rangeProvider() {
        return angle -> Arrays.stream(TorsionRange.values()).filter(torsionRange -> angle.isBetween(torsionRange.begin, torsionRange.end)).findFirst().orElse(INVALID);
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public Angle begin() {
        return this.begin;
    }

    @Override
    public Angle end() {
        return this.end;
    }

    @Override
    public RangeDifference compare(Range other) {
        if (!(other instanceof TorsionRange)) {
            throw new IllegalArgumentException("A Range object can be compared only with other Range object");
        }
        if (this == INVALID || other == INVALID) {
            return RangeDifference.INVALID;
        }
        int delta = (int)Math.round(this.begin.subtract(other.begin()).degrees360());
        return RangeDifference.fromValue(delta / 60);
    }
}

