/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.interfaces.DisplayableExportable;
import pl.poznan.put.torsion.ImmutableTorsionAngleDelta;
import pl.poznan.put.torsion.MasterTorsionAngleType;
import pl.poznan.put.torsion.range.RangeDifference;
import pl.poznan.put.utility.AngleFormat;

@Value.Immutable
public abstract class TorsionAngleDelta
implements DisplayableExportable {
    public static TorsionAngleDelta bothInvalidInstance(MasterTorsionAngleType masterType) {
        return ImmutableTorsionAngleDelta.of(masterType, State.BOTH_INVALID, ImmutableAngle.of(Double.NaN), RangeDifference.INVALID);
    }

    public static TorsionAngleDelta subtractTorsionAngleValues(MasterTorsionAngleType masterType, Angle target, Angle model) {
        State state = State.fromAngles(target, model);
        Angle delta = state == State.BOTH_VALID ? target.subtract(model) : ImmutableAngle.of(Double.NaN);
        RangeDifference rangeDifference = state == State.BOTH_VALID ? masterType.range(target).compare(masterType.range(model)) : RangeDifference.INVALID;
        return ImmutableTorsionAngleDelta.of(masterType, state, delta, rangeDifference);
    }

    @Value.Parameter(order=1)
    public abstract MasterTorsionAngleType angleType();

    @Value.Parameter(order=2)
    public abstract State state();

    @Value.Parameter(order=3)
    public abstract Angle delta();

    @Value.Parameter(order=4)
    public abstract RangeDifference rangeDifference();

    public final String toString(boolean isDisplayable) {
        switch (this.state()) {
            case BOTH_INVALID: {
                return "Missing atoms both in target and model";
            }
            case BOTH_VALID: {
                return isDisplayable ? AngleFormat.degreesRoundedToHundredth(this.delta().radians()) : AngleFormat.degrees(this.delta().radians());
            }
            case TARGET_INVALID: {
                return "Missing atoms in target";
            }
            case MODEL_INVALID: {
                return "Missing atoms in model";
            }
        }
        return "Error";
    }

    @Override
    public final String shortDisplayName() {
        return this.toString(true);
    }

    @Override
    public final String longDisplayName() {
        return this.shortDisplayName();
    }

    @Override
    public final String exportName() {
        return this.toString(false);
    }

    public static enum State {
        TARGET_INVALID,
        MODEL_INVALID,
        BOTH_INVALID,
        BOTH_VALID;


        static State fromAngles(Angle target, Angle model) {
            if (!target.isValid() && !model.isValid()) {
                return BOTH_INVALID;
            }
            if (!target.isValid()) {
                return TARGET_INVALID;
            }
            if (!model.isValid()) {
                return MODEL_INVALID;
            }
            return BOTH_VALID;
        }
    }
}

