/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.BondLength;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.torsion.AtomPair;

@ParametersAreNonnullByDefault
@Generated(from="AtomPair", generator="Immutables")
@Immutable
public final class ImmutableAtomPair
extends AtomPair {
    private final PdbAtomLine leftAtom;
    private final PdbAtomLine rightAtom;
    private volatile transient long lazyInitBitmap;
    private static final long DISTANCE_LAZY_INIT_BIT = 1L;
    private transient double distance;
    private static final long BOND_LENGTH_LAZY_INIT_BIT = 2L;
    private transient BondLength bondLength;

    private ImmutableAtomPair(PdbAtomLine leftAtom, PdbAtomLine rightAtom) {
        this.leftAtom = Objects.requireNonNull(leftAtom, "leftAtom");
        this.rightAtom = Objects.requireNonNull(rightAtom, "rightAtom");
    }

    private ImmutableAtomPair(ImmutableAtomPair original, PdbAtomLine leftAtom, PdbAtomLine rightAtom) {
        this.leftAtom = leftAtom;
        this.rightAtom = rightAtom;
    }

    @Override
    PdbAtomLine leftAtom() {
        return this.leftAtom;
    }

    @Override
    PdbAtomLine rightAtom() {
        return this.rightAtom;
    }

    public final ImmutableAtomPair withLeftAtom(PdbAtomLine value) {
        if (this.leftAtom == value) {
            return this;
        }
        PdbAtomLine newValue = Objects.requireNonNull(value, "leftAtom");
        return new ImmutableAtomPair(this, newValue, this.rightAtom);
    }

    public final ImmutableAtomPair withRightAtom(PdbAtomLine value) {
        if (this.rightAtom == value) {
            return this;
        }
        PdbAtomLine newValue = Objects.requireNonNull(value, "rightAtom");
        return new ImmutableAtomPair(this, this.leftAtom, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAtomPair && this.equalTo((ImmutableAtomPair)another);
    }

    private boolean equalTo(ImmutableAtomPair another) {
        return this.leftAtom.equals(another.leftAtom) && this.rightAtom.equals(another.rightAtom);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.leftAtom.hashCode();
        h += (h << 5) + this.rightAtom.hashCode();
        return h;
    }

    public String toString() {
        return "AtomPair{leftAtom=" + this.leftAtom + ", rightAtom=" + this.rightAtom + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double distance() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableAtomPair immutableAtomPair = this;
            synchronized (immutableAtomPair) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.distance = super.distance();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BondLength bondLength() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableAtomPair immutableAtomPair = this;
            synchronized (immutableAtomPair) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.bondLength = Objects.requireNonNull(super.bondLength(), "bondLength");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.bondLength;
    }

    public static ImmutableAtomPair of(PdbAtomLine leftAtom, PdbAtomLine rightAtom) {
        return new ImmutableAtomPair(leftAtom, rightAtom);
    }

    public static ImmutableAtomPair copyOf(AtomPair instance) {
        if (instance instanceof ImmutableAtomPair) {
            return (ImmutableAtomPair)instance;
        }
        return ImmutableAtomPair.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AtomPair", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LEFT_ATOM = 1L;
        private static final long INIT_BIT_RIGHT_ATOM = 2L;
        private long initBits = 3L;
        @Nullable
        private PdbAtomLine leftAtom;
        @Nullable
        private PdbAtomLine rightAtom;

        private Builder() {
        }

        public final Builder from(AtomPair instance) {
            Objects.requireNonNull(instance, "instance");
            this.leftAtom(instance.leftAtom());
            this.rightAtom(instance.rightAtom());
            return this;
        }

        public final Builder leftAtom(PdbAtomLine leftAtom) {
            this.leftAtom = Objects.requireNonNull(leftAtom, "leftAtom");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rightAtom(PdbAtomLine rightAtom) {
            this.rightAtom = Objects.requireNonNull(rightAtom, "rightAtom");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAtomPair build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAtomPair(null, this.leftAtom, this.rightAtom);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("leftAtom");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rightAtom");
            }
            return "Cannot build AtomPair, some of required attributes are not set " + attributes;
        }
    }
}

