/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.interfaces.DisplayableExportable;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.torsion.AtomBasedTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.types.Quadruple;

@ParametersAreNonnullByDefault
@Generated(from="AtomBasedTorsionAngleType", generator="Immutables")
@Immutable
public final class ImmutableAtomBasedTorsionAngleType
implements AtomBasedTorsionAngleType {
    private final MoleculeType moleculeType;
    private final String shortDisplayName;
    private final String exportName;
    private final Quadruple<AtomName> atoms;
    private final Quadruple<Integer> residueRule;
    private final boolean isPseudoTorsion;

    private ImmutableAtomBasedTorsionAngleType(MoleculeType moleculeType, String shortDisplayName, String exportName, Quadruple<AtomName> atoms, Quadruple<Integer> residueRule) {
        this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
        this.shortDisplayName = Objects.requireNonNull(shortDisplayName, "shortDisplayName");
        this.exportName = Objects.requireNonNull(exportName, "exportName");
        this.atoms = Objects.requireNonNull(atoms, "atoms");
        this.residueRule = Objects.requireNonNull(residueRule, "residueRule");
        this.isPseudoTorsion = AtomBasedTorsionAngleType.super.isPseudoTorsion();
    }

    private ImmutableAtomBasedTorsionAngleType(Builder builder) {
        this.moleculeType = builder.moleculeType;
        this.shortDisplayName = builder.shortDisplayName;
        this.exportName = builder.exportName;
        this.atoms = builder.atoms;
        this.residueRule = builder.residueRule;
        this.isPseudoTorsion = builder.isPseudoTorsionIsSet() ? builder.isPseudoTorsion : AtomBasedTorsionAngleType.super.isPseudoTorsion();
    }

    private ImmutableAtomBasedTorsionAngleType(MoleculeType moleculeType, String shortDisplayName, String exportName, Quadruple<AtomName> atoms, Quadruple<Integer> residueRule, boolean isPseudoTorsion) {
        this.moleculeType = moleculeType;
        this.shortDisplayName = shortDisplayName;
        this.exportName = exportName;
        this.atoms = atoms;
        this.residueRule = residueRule;
        this.isPseudoTorsion = isPseudoTorsion;
    }

    @Override
    public MoleculeType moleculeType() {
        return this.moleculeType;
    }

    @Override
    public String shortDisplayName() {
        return this.shortDisplayName;
    }

    @Override
    public String exportName() {
        return this.exportName;
    }

    @Override
    public Quadruple<AtomName> atoms() {
        return this.atoms;
    }

    @Override
    public Quadruple<Integer> residueRule() {
        return this.residueRule;
    }

    @Override
    public boolean isPseudoTorsion() {
        return this.isPseudoTorsion;
    }

    public final ImmutableAtomBasedTorsionAngleType withMoleculeType(MoleculeType value) {
        if (this.moleculeType == value) {
            return this;
        }
        MoleculeType newValue = Objects.requireNonNull(value, "moleculeType");
        if (this.moleculeType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAtomBasedTorsionAngleType(newValue, this.shortDisplayName, this.exportName, this.atoms, this.residueRule, this.isPseudoTorsion);
    }

    public final ImmutableAtomBasedTorsionAngleType withShortDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "shortDisplayName");
        if (this.shortDisplayName.equals(newValue)) {
            return this;
        }
        return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, newValue, this.exportName, this.atoms, this.residueRule, this.isPseudoTorsion);
    }

    public final ImmutableAtomBasedTorsionAngleType withExportName(String value) {
        String newValue = Objects.requireNonNull(value, "exportName");
        if (this.exportName.equals(newValue)) {
            return this;
        }
        return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, this.shortDisplayName, newValue, this.atoms, this.residueRule, this.isPseudoTorsion);
    }

    public final ImmutableAtomBasedTorsionAngleType withAtoms(Quadruple<AtomName> value) {
        if (this.atoms == value) {
            return this;
        }
        Quadruple<AtomName> newValue = Objects.requireNonNull(value, "atoms");
        return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, this.shortDisplayName, this.exportName, newValue, this.residueRule, this.isPseudoTorsion);
    }

    public final ImmutableAtomBasedTorsionAngleType withResidueRule(Quadruple<Integer> value) {
        if (this.residueRule == value) {
            return this;
        }
        Quadruple<Integer> newValue = Objects.requireNonNull(value, "residueRule");
        return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, this.shortDisplayName, this.exportName, this.atoms, newValue, this.isPseudoTorsion);
    }

    public final ImmutableAtomBasedTorsionAngleType withIsPseudoTorsion(boolean value) {
        if (this.isPseudoTorsion == value) {
            return this;
        }
        return new ImmutableAtomBasedTorsionAngleType(this.moleculeType, this.shortDisplayName, this.exportName, this.atoms, this.residueRule, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAtomBasedTorsionAngleType && this.equalTo((ImmutableAtomBasedTorsionAngleType)another);
    }

    private boolean equalTo(ImmutableAtomBasedTorsionAngleType another) {
        return this.moleculeType.equals((Object)another.moleculeType) && this.shortDisplayName.equals(another.shortDisplayName) && this.exportName.equals(another.exportName) && this.atoms.equals(another.atoms) && this.residueRule.equals(another.residueRule) && this.isPseudoTorsion == another.isPseudoTorsion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.moleculeType.hashCode();
        h += (h << 5) + this.shortDisplayName.hashCode();
        h += (h << 5) + this.exportName.hashCode();
        h += (h << 5) + this.atoms.hashCode();
        h += (h << 5) + this.residueRule.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isPseudoTorsion);
        return h;
    }

    public String toString() {
        return "AtomBasedTorsionAngleType{moleculeType=" + (Object)((Object)this.moleculeType) + ", shortDisplayName=" + this.shortDisplayName + ", exportName=" + this.exportName + ", atoms=" + this.atoms + ", residueRule=" + this.residueRule + ", isPseudoTorsion=" + this.isPseudoTorsion + "}";
    }

    public static ImmutableAtomBasedTorsionAngleType of(MoleculeType moleculeType, String shortDisplayName, String exportName, Quadruple<AtomName> atoms, Quadruple<Integer> residueRule) {
        return new ImmutableAtomBasedTorsionAngleType(moleculeType, shortDisplayName, exportName, atoms, residueRule);
    }

    public static ImmutableAtomBasedTorsionAngleType copyOf(AtomBasedTorsionAngleType instance) {
        if (instance instanceof ImmutableAtomBasedTorsionAngleType) {
            return (ImmutableAtomBasedTorsionAngleType)instance;
        }
        return ImmutableAtomBasedTorsionAngleType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AtomBasedTorsionAngleType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MOLECULE_TYPE = 1L;
        private static final long INIT_BIT_SHORT_DISPLAY_NAME = 2L;
        private static final long INIT_BIT_EXPORT_NAME = 4L;
        private static final long INIT_BIT_ATOMS = 8L;
        private static final long INIT_BIT_RESIDUE_RULE = 16L;
        private static final long OPT_BIT_IS_PSEUDO_TORSION = 1L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private MoleculeType moleculeType;
        @Nullable
        private String shortDisplayName;
        @Nullable
        private String exportName;
        @Nullable
        private Quadruple<AtomName> atoms;
        @Nullable
        private Quadruple<Integer> residueRule;
        private boolean isPseudoTorsion;

        private Builder() {
        }

        public final Builder from(AtomBasedTorsionAngleType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TorsionAngleType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DisplayableExportable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DisplayableExportable instance;
            long bits = 0L;
            if (object instanceof AtomBasedTorsionAngleType) {
                instance = (AtomBasedTorsionAngleType)object;
                if ((bits & 1L) == 0L) {
                    this.shortDisplayName(instance.shortDisplayName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.moleculeType(instance.moleculeType());
                    bits |= 2L;
                }
                this.residueRule(instance.residueRule());
                if ((bits & 4L) == 0L) {
                    this.exportName(instance.exportName());
                    bits |= 4L;
                }
                this.isPseudoTorsion(instance.isPseudoTorsion());
                this.atoms(instance.atoms());
            }
            if (object instanceof TorsionAngleType) {
                instance = (TorsionAngleType)object;
                if ((bits & 2L) == 0L) {
                    this.moleculeType(instance.moleculeType());
                    bits |= 2L;
                }
            }
            if (object instanceof DisplayableExportable) {
                instance = (DisplayableExportable)object;
                if ((bits & 1L) == 0L) {
                    this.shortDisplayName(instance.shortDisplayName());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.exportName(instance.exportName());
                    bits |= 4L;
                }
            }
        }

        public final Builder moleculeType(MoleculeType moleculeType) {
            this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder shortDisplayName(String shortDisplayName) {
            this.shortDisplayName = Objects.requireNonNull(shortDisplayName, "shortDisplayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder exportName(String exportName) {
            this.exportName = Objects.requireNonNull(exportName, "exportName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder atoms(Quadruple<AtomName> atoms) {
            this.atoms = Objects.requireNonNull(atoms, "atoms");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder residueRule(Quadruple<Integer> residueRule) {
            this.residueRule = Objects.requireNonNull(residueRule, "residueRule");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder isPseudoTorsion(boolean isPseudoTorsion) {
            this.isPseudoTorsion = isPseudoTorsion;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAtomBasedTorsionAngleType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAtomBasedTorsionAngleType(this);
        }

        private boolean isPseudoTorsionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("moleculeType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("shortDisplayName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("exportName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("atoms");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("residueRule");
            }
            return "Cannot build AtomBasedTorsionAngleType, some of required attributes are not set " + attributes;
        }
    }
}

