/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.samples.AngleSample;
import pl.poznan.put.circular.samples.ImmutableAngleSample;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.torsion.ImmutableAverageTorsionAngleType;
import pl.poznan.put.torsion.ImmutableTorsionAngleValue;
import pl.poznan.put.torsion.MasterTorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleValue;
import pl.poznan.put.torsion.range.Range;
import pl.poznan.put.torsion.range.TorsionRange;

@Value.Immutable
public abstract class AverageTorsionAngleType
implements TorsionAngleType,
MasterTorsionAngleType {
    public static AverageTorsionAngleType forProtein() {
        return ImmutableAverageTorsionAngleType.of(MoleculeType.PROTEIN, MoleculeType.PROTEIN.mainAngleTypes());
    }

    public static AverageTorsionAngleType forNucleicAcid() {
        return ImmutableAverageTorsionAngleType.of(MoleculeType.RNA, MoleculeType.RNA.mainAngleTypes());
    }

    @Override
    @Value.Parameter(order=1)
    public abstract MoleculeType moleculeType();

    @Override
    public final TorsionAngleValue calculate(List<PdbResidue> residues, int currentIndex) {
        List<Angle> angles = residues.get(currentIndex).residueInformationProvider().torsionAngleTypes().stream().filter(this.consideredBasicAngleTypes()::contains).map(angleType -> angleType.calculate(residues, currentIndex)).map(TorsionAngleValue::value).collect(Collectors.toList());
        ImmutableAngleSample angleSample = ImmutableAngleSample.of(angles);
        return ImmutableTorsionAngleValue.of(this, ((AngleSample)angleSample).meanDirection());
    }

    @Value.Parameter(order=2)
    public abstract List<MasterTorsionAngleType> consideredAngles();

    @Override
    @Value.Lazy
    public String shortDisplayName() {
        LinkedHashSet<String> angleNames = new LinkedHashSet<String>();
        for (MasterTorsionAngleType angleType : this.consideredAngles()) {
            angleNames.add(angleType.shortDisplayName());
        }
        StringBuilder builder = new StringBuilder("MCQ(");
        Iterator iterator = angleNames.iterator();
        builder.append((String)iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ");
            builder.append((String)iterator.next());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public String longDisplayName() {
        return this.shortDisplayName();
    }

    @Override
    @Value.Lazy
    public String exportName() {
        LinkedHashSet<String> angleNames = new LinkedHashSet<String>();
        for (MasterTorsionAngleType angleType : this.consideredAngles()) {
            angleNames.add(angleType.exportName());
        }
        StringBuilder builder = new StringBuilder("MCQ_");
        Iterator iterator = angleNames.iterator();
        builder.append((String)iterator.next());
        while (iterator.hasNext()) {
            builder.append('_');
            builder.append((String)iterator.next());
        }
        return builder.toString();
    }

    public final TorsionAngleValue calculate(Collection<TorsionAngleValue> values) {
        List<Angle> angles = values.stream().filter(angleValue -> this.consideredBasicAngleTypes().contains(angleValue.angleType())).map(TorsionAngleValue::value).collect(Collectors.toList());
        ImmutableAngleSample angleSample = ImmutableAngleSample.of(angles);
        return ImmutableTorsionAngleValue.of(this, ((AngleSample)angleSample).meanDirection());
    }

    @Override
    public final List<TorsionAngleType> angleTypes() {
        return Collections.singletonList(this);
    }

    @Override
    public final Range range(Angle angle) {
        return TorsionRange.rangeProvider().fromAngle(angle);
    }

    @Value.Lazy
    protected Set<TorsionAngleType> consideredBasicAngleTypes() {
        return this.consideredAngles().stream().map(MasterTorsionAngleType::angleTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

