/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import java.util.Locale;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.atom.Bond;
import pl.poznan.put.atom.BondLength;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbResidueIdentifier;

@Value.Immutable
public abstract class AtomPair
implements Comparable<AtomPair> {
    @Value.Parameter(order=1)
    abstract PdbAtomLine leftAtom();

    @Value.Parameter(order=2)
    abstract PdbAtomLine rightAtom();

    public final String generateValidationMessage() {
        PdbResidueIdentifier rightIdentifier;
        if (this.isValid()) {
            return "";
        }
        PdbResidueIdentifier leftIdentifier = PdbResidueIdentifier.from(this.leftAtom());
        if (leftIdentifier.equals(rightIdentifier = PdbResidueIdentifier.from(this.rightAtom()))) {
            return String.format(Locale.US, "%s-%s distance in %s is %.2f but should be in range [%.2f; %.2f]", this.leftAtom().atomName(), this.rightAtom().atomName(), leftIdentifier, this.distance(), this.bondLength().min(), this.bondLength().max());
        }
        return String.format(Locale.US, "%s-%s distance between %s and %s is %.2f but should be in range [%.2f; %.2f]", this.leftAtom().atomName(), this.rightAtom().atomName(), leftIdentifier, rightIdentifier, this.distance(), this.bondLength().min(), this.bondLength().max());
    }

    @Override
    public final int compareTo(AtomPair t) {
        return Integer.compare(this.leftAtom().serialNumber(), t.leftAtom().serialNumber());
    }

    @Value.Lazy
    protected double distance() {
        return this.leftAtom().distanceTo(this.rightAtom());
    }

    @Value.Lazy
    protected BondLength bondLength() {
        AtomName leftAtomName = this.leftAtom().detectAtomName();
        AtomName rightAtomName = this.rightAtom().detectAtomName();
        return Bond.length(leftAtomName.getType(), rightAtomName.getType());
    }

    private boolean isValid() {
        return this.distance() <= this.bondLength().max() * 1.5;
    }
}

