/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.torsion.AtomPair;
import pl.poznan.put.torsion.ImmutableAtomPair;
import pl.poznan.put.torsion.ImmutableTorsionAngleValue;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleValue;
import pl.poznan.put.types.Quadruple;

@Value.Immutable
public interface AtomBasedTorsionAngleType
extends TorsionAngleType {
    @Override
    @Value.Parameter(order=1)
    public MoleculeType moleculeType();

    @Override
    default public TorsionAngleValue calculate(List<PdbResidue> residues, int currentIndex) {
        List<AtomPair> atomPairs = this.findAtomPairs(residues, currentIndex);
        if (atomPairs.size() != 3) {
            return ImmutableTorsionAngleValue.of(this, ImmutableAngle.of(Double.NaN));
        }
        return ImmutableTorsionAngleValue.of(this, Angle.torsionAngle(atomPairs.get(0).leftAtom().toVector3D(), atomPairs.get(1).leftAtom().toVector3D(), atomPairs.get(2).leftAtom().toVector3D(), atomPairs.get(2).rightAtom().toVector3D()));
    }

    @Override
    @Value.Parameter(order=2)
    public String shortDisplayName();

    @Override
    default public String longDisplayName() {
        return String.format("%s (%s) %s-%s-%s-%s", new Object[]{this.shortDisplayName(), this.exportName(), this.atoms().a(), this.atoms().b(), this.atoms().c(), this.atoms().d()});
    }

    @Override
    @Value.Parameter(order=3)
    public String exportName();

    @Value.Parameter(order=4)
    public Quadruple<AtomName> atoms();

    @Value.Parameter(order=5)
    public Quadruple<Integer> residueRule();

    @Value.Default
    default public boolean isPseudoTorsion() {
        return false;
    }

    default public TorsionAngleValue calculate(PdbAtomLine a1, PdbAtomLine a2, PdbAtomLine a3, PdbAtomLine a4) {
        return ImmutableTorsionAngleValue.of(this, Angle.torsionAngle(a1.toVector3D(), a2.toVector3D(), a3.toVector3D(), a4.toVector3D()));
    }

    default public List<AtomPair> findAtomPairs(List<PdbResidue> residues, int currentIndex) {
        ArrayList<PdbAtomLine> foundAtoms = new ArrayList<PdbAtomLine>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            int index = currentIndex + this.residueRule().get(i2);
            if (index < 0 || index >= residues.size()) {
                return Collections.emptyList();
            }
            PdbResidue residue = residues.get(index);
            if (!residue.hasAtom(this.atoms().get(i2))) {
                return Collections.emptyList();
            }
            foundAtoms.add(residue.findAtom(this.atoms().get(i2)));
        }
        return IntStream.range(1, 4).mapToObj(i -> ImmutableAtomPair.of((PdbAtomLine)foundAtoms.get(i - 1), (PdbAtomLine)foundAtoms.get(i))).collect(Collectors.toList());
    }
}

