/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.elimination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.immutables.value.Value;
import pl.poznan.put.structure.pseudoknots.ConflictGraph;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.elimination.AbstractRegionRemover;
import pl.poznan.put.structure.pseudoknots.elimination.MaxConflicts;

@Value.Immutable(singleton=true)
public abstract class MinGain
extends AbstractRegionRemover {
    static List<Region> minGainRegions(ConflictGraph conflictGraph, Collection<Region> regions) {
        TreeMap map = new TreeMap();
        regions.forEach(region -> {
            int gain = region.length() - conflictGraph.conflictsWith((Region)region).stream().mapToInt(Region::length).sum();
            map.putIfAbsent(gain, new ArrayList());
            ((List)map.get(gain)).add(region);
        });
        return (List)map.get(map.firstKey());
    }

    @Override
    public final Region selectRegionToRemove(ConflictGraph conflictGraph) {
        Set<Region> regions = conflictGraph.regionsWithConflicts();
        List<Region> minGainRegions = MinGain.minGainRegions(conflictGraph, regions);
        if (minGainRegions.size() == 1) {
            return minGainRegions.get(0);
        }
        List<Region> maxConflictsRegions = MaxConflicts.maxConflictRegions(conflictGraph, minGainRegions);
        if (maxConflictsRegions.size() == 1) {
            return maxConflictsRegions.get(0);
        }
        maxConflictsRegions.sort(Comparator.comparingInt(Region::begin));
        return maxConflictsRegions.get(maxConflictsRegions.size() - 1);
    }
}

