/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.elimination;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.ImmutableBpSeq;
import pl.poznan.put.structure.pseudoknots.ConflictGraph;
import pl.poznan.put.structure.pseudoknots.ImmutableConflictGraph;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.elimination.RegionRemover;

public abstract class AbstractRegionRemover
implements RegionRemover {
    private static void restoreNonConflicting(Iterable<Region> regions, Collection<Region> removedRegions) {
        for (Region ri : regions) {
            if (!removedRegions.contains(ri)) continue;
            boolean nonConflicting = true;
            for (Region rj : regions) {
                if (removedRegions.contains(rj) || !ConflictGraph.isConflicting(ri, rj)) continue;
                nonConflicting = false;
                break;
            }
            if (!nonConflicting) continue;
            removedRegions.remove(ri);
        }
    }

    @Override
    public final List<BpSeq> findPseudoknots(BpSeq bpSeq) {
        List<Region> regions = Region.createRegions(bpSeq);
        ImmutableConflictGraph conflictGraph = ImmutableConflictGraph.of(regions);
        HashSet<Region> removedRegions = new HashSet<Region>();
        while (conflictGraph.hasConflicts()) {
            Region region2 = this.selectRegionToRemove(conflictGraph);
            removedRegions.add(region2);
            conflictGraph.removeRegion(region2);
        }
        AbstractRegionRemover.restoreNonConflicting(regions, removedRegions);
        List nonPseudoknotted = regions.stream().filter(region -> !removedRegions.contains(region)).map(Region::entries).flatMap(Collection::stream).collect(Collectors.toList());
        BpSeq result = ImmutableBpSeq.copyOf(bpSeq);
        for (BpSeq.Entry entry : nonPseudoknotted) {
            result = result.withoutPair(entry);
        }
        return Collections.singletonList(result);
    }
}

