/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.dp;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.dp.ImmutableSubSolution;

@Value.Immutable
abstract class SubSolution {
    SubSolution() {
    }

    public static SubSolution merge(SubSolution left, SubSolution below) {
        return ImmutableSubSolution.of(Stream.concat(left.regions().stream(), below.regions().stream()).collect(Collectors.toList()));
    }

    @Value.Parameter(order=1)
    public abstract List<Region> regions();

    @Value.Lazy
    public int score() {
        return this.regions().stream().mapToInt(Region::length).sum();
    }

    @Value.Lazy
    public int lowestEndpoint() {
        return this.regions().stream().map(Region::begin).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
    }

    @Value.Lazy
    public int highestEndpoint() {
        return this.regions().stream().map(Region::end).max(Integer::compareTo).orElse(Integer.MIN_VALUE);
    }
}

