/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.dp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.dp.SubSolution;

@ParametersAreNonnullByDefault
@Generated(from="SubSolution", generator="Immutables")
@Immutable
final class ImmutableSubSolution
extends SubSolution {
    private final List<Region> regions;
    private volatile transient long lazyInitBitmap;
    private static final long SCORE_LAZY_INIT_BIT = 1L;
    private transient int score;
    private static final long LOWEST_ENDPOINT_LAZY_INIT_BIT = 2L;
    private transient int lowestEndpoint;
    private static final long HIGHEST_ENDPOINT_LAZY_INIT_BIT = 4L;
    private transient int highestEndpoint;

    private ImmutableSubSolution(Iterable<? extends Region> regions) {
        this.regions = ImmutableSubSolution.createUnmodifiableList(false, ImmutableSubSolution.createSafeList(regions, true, false));
    }

    private ImmutableSubSolution(ImmutableSubSolution original, List<Region> regions) {
        this.regions = regions;
    }

    @Override
    public List<Region> regions() {
        return this.regions;
    }

    public final ImmutableSubSolution withRegions(Region ... elements) {
        List<Region> newValue = ImmutableSubSolution.createUnmodifiableList(false, ImmutableSubSolution.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSubSolution(this, newValue);
    }

    public final ImmutableSubSolution withRegions(Iterable<? extends Region> elements) {
        if (this.regions == elements) {
            return this;
        }
        List<Region> newValue = ImmutableSubSolution.createUnmodifiableList(false, ImmutableSubSolution.createSafeList(elements, true, false));
        return new ImmutableSubSolution(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubSolution && this.equalTo((ImmutableSubSolution)another);
    }

    private boolean equalTo(ImmutableSubSolution another) {
        return this.regions.equals(another.regions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.regions.hashCode();
        return h;
    }

    public String toString() {
        return "SubSolution{regions=" + this.regions + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int score() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSubSolution immutableSubSolution = this;
            synchronized (immutableSubSolution) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.score = super.score();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lowestEndpoint() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSubSolution immutableSubSolution = this;
            synchronized (immutableSubSolution) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.lowestEndpoint = super.lowestEndpoint();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.lowestEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int highestEndpoint() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableSubSolution immutableSubSolution = this;
            synchronized (immutableSubSolution) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.highestEndpoint = super.highestEndpoint();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.highestEndpoint;
    }

    public static ImmutableSubSolution of(List<Region> regions) {
        return ImmutableSubSolution.of(regions);
    }

    public static ImmutableSubSolution of(Iterable<? extends Region> regions) {
        return new ImmutableSubSolution(regions);
    }

    public static ImmutableSubSolution copyOf(SubSolution instance) {
        if (instance instanceof ImmutableSubSolution) {
            return (ImmutableSubSolution)instance;
        }
        return ImmutableSubSolution.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SubSolution", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Region> regions = new ArrayList<Region>();

        private Builder() {
        }

        public final Builder from(SubSolution instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllRegions(instance.regions());
            return this;
        }

        public final Builder addRegions(Region element) {
            this.regions.add(Objects.requireNonNull(element, "regions element"));
            return this;
        }

        public final Builder addRegions(Region ... elements) {
            for (Region element : elements) {
                this.regions.add(Objects.requireNonNull(element, "regions element"));
            }
            return this;
        }

        public final Builder regions(Iterable<? extends Region> elements) {
            this.regions.clear();
            return this.addAllRegions(elements);
        }

        public final Builder addAllRegions(Iterable<? extends Region> elements) {
            for (Region region : elements) {
                this.regions.add(Objects.requireNonNull(region, "regions element"));
            }
            return this;
        }

        public ImmutableSubSolution build() {
            return new ImmutableSubSolution(null, ImmutableSubSolution.createUnmodifiableList(true, this.regions));
        }
    }
}

