/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.dp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.immutables.value.Value;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.formats.ImmutableBpSeq;
import pl.poznan.put.structure.pseudoknots.ConflictGraph;
import pl.poznan.put.structure.pseudoknots.ImmutableConflictGraph;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.dp.ConflictClique;
import pl.poznan.put.structure.pseudoknots.dp.DynamicProgramming;
import pl.poznan.put.structure.pseudoknots.dp.ImmutableSubSolution;
import pl.poznan.put.structure.pseudoknots.dp.SubSolution;
import pl.poznan.put.structure.pseudoknots.elimination.RegionRemover;

@Value.Immutable(singleton=true)
public abstract class DynamicProgrammingAll
implements DynamicProgramming {
    private static SubSolution[] solveSingleCase(SubSolution[][][] matrix, ConflictClique conflictClique, int i, int j) {
        Optional<Region> region;
        int size = conflictClique.endpointCount();
        HashSet<SubSolution> candidates = new HashSet<SubSolution>(size);
        if (matrix[i][j - 1].length > 0) {
            candidates.addAll(Arrays.asList(matrix[i][j - 1]));
        }
        if (matrix[i + 1][j].length > 0) {
            candidates.addAll(Arrays.asList(matrix[i + 1][j]));
        }
        if ((region = conflictClique.findRegion(conflictClique.endpoint(i), conflictClique.endpoint(j))).isPresent()) {
            ImmutableSubSolution current = ImmutableSubSolution.of(Collections.singletonList(region.get()));
            if (matrix[i + 1][j - 1].length > 0) {
                for (SubSolution subSolution : matrix[i + 1][j - 1]) {
                    candidates.add(SubSolution.merge(subSolution, current));
                }
            } else {
                candidates.add(current);
            }
        }
        candidates.addAll(DynamicProgrammingAll.merge(matrix, conflictClique, i, j));
        List<SubSolution> bestCandidates = DynamicProgrammingAll.selectBestCandidates(candidates);
        return bestCandidates.toArray(new SubSolution[0]);
    }

    private static Collection<SubSolution> merge(SubSolution[][][] matrix, ConflictClique conflictClique, int i, int j) {
        SubSolution[] left = matrix[i][j - 1];
        SubSolution[] below = matrix[i + 1][j];
        if (left.length == 0 || below.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SubSolution> result = new ArrayList<SubSolution>();
        for (SubSolution leftSub : left) {
            int highestEndpoint = leftSub.highestEndpoint();
            for (SubSolution belowSub : below) {
                int lowestEndpoint = belowSub.lowestEndpoint();
                if (highestEndpoint < lowestEndpoint) {
                    result.add(SubSolution.merge(leftSub, belowSub));
                    continue;
                }
                int begin = conflictClique.indexOfEndpoint(lowestEndpoint) - 1;
                int end = conflictClique.indexOfEndpoint(highestEndpoint) + 1;
                for (int k = begin; k < end; ++k) {
                    for (SubSolution s1 : matrix[i][k]) {
                        for (SubSolution s2 : matrix[k + 1][j]) {
                            result.add(SubSolution.merge(s1, s2));
                        }
                    }
                }
            }
        }
        return result;
    }

    private static List<SubSolution> selectBestCandidates(Collection<SubSolution> candidates) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        TreeMap map = new TreeMap();
        candidates.forEach(subSolution -> {
            int score = subSolution.score();
            map.putIfAbsent(score, new ArrayList());
            ((List)map.get(score)).add(subSolution);
        });
        return (List)map.get(map.lastKey());
    }

    protected abstract Optional<RegionRemover> regionRemover();

    @Override
    public final List<SubSolution> findOptimalSolutions(ConflictClique conflictClique) {
        int size = conflictClique.endpointCount();
        SubSolution[][][] matrix = new SubSolution[size][size][0];
        for (int j = 1; j < size; ++j) {
            for (int i = j - 1; i >= 0; --i) {
                matrix[i][j] = DynamicProgrammingAll.solveSingleCase(matrix, conflictClique, i, j);
            }
        }
        return Arrays.asList(matrix[0][size - 1]);
    }

    @Override
    public final List<BpSeq> findPseudoknots(BpSeq bpSeq) {
        List<Region> regions = Region.createRegions(bpSeq);
        ConflictGraph conflictGraph = ImmutableConflictGraph.of(regions).simplified();
        ArrayList<BpSeq.Entry> nonConflicting = new ArrayList<BpSeq.Entry>();
        for (Region region : regions) {
            if (conflictGraph.hasConflicts(region)) continue;
            nonConflicting.addAll(region.entries());
        }
        if (this.regionRemover().isPresent()) {
            int max;
            do {
                max = Integer.MIN_VALUE;
                for (ConflictClique conflictClique : conflictGraph.conflictCliques()) {
                    if (conflictClique.size() <= max) continue;
                    max = conflictClique.size();
                }
                if (max <= this.maxCliqueSize()) continue;
                conflictGraph.removeRegion(this.regionRemover().get().selectRegionToRemove(conflictGraph));
            } while (max > this.maxCliqueSize());
        }
        ArrayList<ArrayList<BpSeq.Entry>> results = new ArrayList<ArrayList<BpSeq.Entry>>();
        results.add(nonConflicting);
        List<ConflictClique> list = conflictGraph.conflictCliques();
        for (ConflictClique conflictClique : list) {
            ArrayList arrayList = new ArrayList();
            List<SubSolution> solutions = this.findOptimalSolutions(conflictClique);
            for (SubSolution solution : solutions) {
                for (List list2 : results) {
                    ArrayList<BpSeq.Entry> nextResult = new ArrayList<BpSeq.Entry>(list2);
                    for (Region region : solution.regions()) {
                        nextResult.addAll(region.entries());
                    }
                    arrayList.add(nextResult);
                }
            }
            results = arrayList;
        }
        ArrayList<BpSeq> arrayList = new ArrayList<BpSeq>();
        for (List list3 : results) {
            BpSeq nextBpSeq = ImmutableBpSeq.copyOf(bpSeq);
            for (BpSeq.Entry entry : list3) {
                nextBpSeq = nextBpSeq.withoutPair(entry);
            }
            arrayList.add(nextBpSeq);
        }
        return arrayList;
    }

    @Value.Default
    protected int maxCliqueSize() {
        return Integer.MAX_VALUE;
    }
}

