/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots.dp;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import pl.poznan.put.structure.pseudoknots.Region;

@Value.Immutable
public abstract class ConflictClique {
    @Value.Parameter(order=1)
    public abstract Set<Region> regions();

    public final Optional<Region> findRegion(int begin, int end) {
        return this.regions().stream().filter(region -> region.begin() == begin).filter(region -> region.end() == end).findFirst();
    }

    public final int endpoint(int index) {
        return this.sortedEndpoints().get(index);
    }

    public final int endpointCount() {
        return this.sortedEndpoints().size();
    }

    public final int indexOfEndpoint(int endpoint) {
        return this.sortedEndpoints().indexOf(endpoint);
    }

    public final int size() {
        return this.regions().size();
    }

    @Value.Lazy
    protected List<Integer> sortedEndpoints() {
        return this.regions().stream().flatMap(region -> Stream.of(region.begin(), region.end())).sorted(Integer::compareTo).collect(Collectors.toList());
    }
}

