/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.immutables.value.Value;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.pseudoknots.ImmutableRegion;

@Value.Immutable
public abstract class Region
implements Comparable<Region> {
    public static List<Region> createRegions(BpSeq bpSeq) {
        ArrayList<Region> regions = new ArrayList<Region>();
        ArrayList<BpSeq.Entry> regionEntries = new ArrayList<BpSeq.Entry>();
        ArrayList<BpSeq.Entry> allEntries = new ArrayList<BpSeq.Entry>(bpSeq.paired());
        for (BpSeq.Entry entry : allEntries) {
            if (regionEntries.isEmpty()) {
                regionEntries.add(entry);
                continue;
            }
            BpSeq.Entry last = (BpSeq.Entry)regionEntries.get(regionEntries.size() - 1);
            if (entry.index() == last.index() + 1 && entry.pair() == last.pair() - 1) {
                regionEntries.add(entry);
                continue;
            }
            regions.add(ImmutableRegion.of(regionEntries));
            regionEntries.clear();
            regionEntries.add(entry);
        }
        if (!regionEntries.isEmpty()) {
            regions.add(ImmutableRegion.of(regionEntries));
        }
        return regions;
    }

    public static Region merge(Region ... regions) {
        List<BpSeq.Entry> entries = Arrays.stream(regions).map(Region::entries).flatMap(Collection::stream).collect(Collectors.toList());
        int begin = entries.stream().map(BpSeq.Entry::index).min(Integer::compareTo).orElse(0);
        int end = entries.stream().map(BpSeq.Entry::pair).max(Integer::compareTo).orElse(0);
        return ImmutableRegion.of(entries).withBegin(begin).withEnd(end);
    }

    @Value.Parameter(order=1)
    public abstract List<BpSeq.Entry> entries();

    public final int length() {
        return this.entries().size();
    }

    @Value.Default
    public int begin() {
        return this.entries().get(0).index();
    }

    @Value.Default
    public int end() {
        return this.entries().get(0).pair();
    }

    @Value.Default
    @Value.Auxiliary
    public boolean isRemoved() {
        return false;
    }

    @Override
    public final int compareTo(Region t) {
        return new CompareToBuilder().append(this.begin(), t.begin()).append(this.end(), t.end()).build();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append("begin", this.begin()).append("end", this.end()).append("length", this.length()).toString();
    }
}

