/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.formats.BpSeq;
import pl.poznan.put.structure.pseudoknots.Region;

@ParametersAreNonnullByDefault
@Generated(from="Region", generator="Immutables")
@Immutable
public final class ImmutableRegion
extends Region {
    private final List<BpSeq.Entry> entries;
    private final int begin;
    private final int end;
    private final boolean isRemoved;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRegion(Iterable<? extends BpSeq.Entry> entries) {
        this.entries = ImmutableRegion.createUnmodifiableList(false, ImmutableRegion.createSafeList(entries, true, false));
        this.begin = this.initShim.begin();
        this.end = this.initShim.end();
        this.isRemoved = this.initShim.isRemoved();
        this.initShim = null;
    }

    private ImmutableRegion(Builder builder) {
        this.entries = ImmutableRegion.createUnmodifiableList(true, builder.entries);
        if (builder.beginIsSet()) {
            this.initShim.begin(builder.begin);
        }
        if (builder.endIsSet()) {
            this.initShim.end(builder.end);
        }
        if (builder.isRemovedIsSet()) {
            this.initShim.isRemoved(builder.isRemoved);
        }
        this.begin = this.initShim.begin();
        this.end = this.initShim.end();
        this.isRemoved = this.initShim.isRemoved();
        this.initShim = null;
    }

    private ImmutableRegion(List<BpSeq.Entry> entries, int begin, int end, boolean isRemoved) {
        this.entries = entries;
        this.begin = begin;
        this.end = end;
        this.isRemoved = isRemoved;
        this.initShim = null;
    }

    @Override
    public List<BpSeq.Entry> entries() {
        return this.entries;
    }

    @Override
    public int begin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.begin() : this.begin;
    }

    @Override
    public int end() {
        InitShim shim = this.initShim;
        return shim != null ? shim.end() : this.end;
    }

    @Override
    public boolean isRemoved() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRemoved() : this.isRemoved;
    }

    public final ImmutableRegion withEntries(BpSeq.Entry ... elements) {
        List<BpSeq.Entry> newValue = ImmutableRegion.createUnmodifiableList(false, ImmutableRegion.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRegion(newValue, this.begin, this.end, this.isRemoved);
    }

    public final ImmutableRegion withEntries(Iterable<? extends BpSeq.Entry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<BpSeq.Entry> newValue = ImmutableRegion.createUnmodifiableList(false, ImmutableRegion.createSafeList(elements, true, false));
        return new ImmutableRegion(newValue, this.begin, this.end, this.isRemoved);
    }

    public final ImmutableRegion withBegin(int value) {
        if (this.begin == value) {
            return this;
        }
        return new ImmutableRegion(this.entries, value, this.end, this.isRemoved);
    }

    public final ImmutableRegion withEnd(int value) {
        if (this.end == value) {
            return this;
        }
        return new ImmutableRegion(this.entries, this.begin, value, this.isRemoved);
    }

    public final ImmutableRegion withIsRemoved(boolean value) {
        if (this.isRemoved == value) {
            return this;
        }
        return new ImmutableRegion(this.entries, this.begin, this.end, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegion && this.equalTo((ImmutableRegion)another);
    }

    private boolean equalTo(ImmutableRegion another) {
        return this.entries.equals(another.entries) && this.begin == another.begin && this.end == another.end;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.begin;
        h += (h << 5) + this.end;
        return h;
    }

    public static ImmutableRegion of(List<BpSeq.Entry> entries) {
        return ImmutableRegion.of(entries);
    }

    public static ImmutableRegion of(Iterable<? extends BpSeq.Entry> entries) {
        return new ImmutableRegion(entries);
    }

    public static ImmutableRegion copyOf(Region instance) {
        if (instance instanceof ImmutableRegion) {
            return (ImmutableRegion)instance;
        }
        return ImmutableRegion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Region", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_BEGIN = 1L;
        private static final long OPT_BIT_END = 2L;
        private static final long OPT_BIT_IS_REMOVED = 4L;
        private long optBits;
        private List<BpSeq.Entry> entries = new ArrayList<BpSeq.Entry>();
        private int begin;
        private int end;
        private boolean isRemoved;

        private Builder() {
        }

        public final Builder from(Region instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEntries(instance.entries());
            this.begin(instance.begin());
            this.end(instance.end());
            this.isRemoved(instance.isRemoved());
            return this;
        }

        public final Builder addEntries(BpSeq.Entry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        public final Builder addEntries(BpSeq.Entry ... elements) {
            for (BpSeq.Entry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        public final Builder entries(Iterable<? extends BpSeq.Entry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends BpSeq.Entry> elements) {
            for (BpSeq.Entry entry : elements) {
                this.entries.add(Objects.requireNonNull(entry, "entries element"));
            }
            return this;
        }

        public final Builder begin(int begin) {
            this.begin = begin;
            this.optBits |= 1L;
            return this;
        }

        public final Builder end(int end) {
            this.end = end;
            this.optBits |= 2L;
            return this;
        }

        public final Builder isRemoved(boolean isRemoved) {
            this.isRemoved = isRemoved;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableRegion build() {
            return new ImmutableRegion(this);
        }

        private boolean beginIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean endIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isRemovedIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="Region", generator="Immutables")
    private final class InitShim {
        private byte beginBuildStage = 0;
        private int begin;
        private byte endBuildStage = 0;
        private int end;
        private byte isRemovedBuildStage = 0;
        private boolean isRemoved;

        private InitShim() {
        }

        int begin() {
            if (this.beginBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.beginBuildStage == 0) {
                this.beginBuildStage = (byte)-1;
                this.begin = ImmutableRegion.super.begin();
                this.beginBuildStage = 1;
            }
            return this.begin;
        }

        void begin(int begin) {
            this.begin = begin;
            this.beginBuildStage = 1;
        }

        int end() {
            if (this.endBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.endBuildStage == 0) {
                this.endBuildStage = (byte)-1;
                this.end = ImmutableRegion.super.end();
                this.endBuildStage = 1;
            }
            return this.end;
        }

        void end(int end) {
            this.end = end;
            this.endBuildStage = 1;
        }

        boolean isRemoved() {
            if (this.isRemovedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isRemovedBuildStage == 0) {
                this.isRemovedBuildStage = (byte)-1;
                this.isRemoved = ImmutableRegion.super.isRemoved();
                this.isRemovedBuildStage = 1;
            }
            return this.isRemoved;
        }

        void isRemoved(boolean isRemoved) {
            this.isRemoved = isRemoved;
            this.isRemovedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.beginBuildStage == -1) {
                attributes.add("begin");
            }
            if (this.endBuildStage == -1) {
                attributes.add("end");
            }
            if (this.isRemovedBuildStage == -1) {
                attributes.add("isRemoved");
            }
            return "Cannot build Region, attribute initializers form cycle " + attributes;
        }
    }
}

