/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.structure.pseudoknots.ConflictGraph;
import pl.poznan.put.structure.pseudoknots.Region;

@ParametersAreNonnullByDefault
@Generated(from="ConflictGraph", generator="Immutables")
@Immutable
public final class ImmutableConflictGraph
extends ConflictGraph {
    private final List<Region> regions;
    private volatile transient long lazyInitBitmap;
    private static final long CONFLICTS_LAZY_INIT_BIT = 1L;
    private transient Map<Region, Set<Region>> conflicts;

    private ImmutableConflictGraph(Iterable<? extends Region> regions) {
        this.regions = ImmutableConflictGraph.createUnmodifiableList(false, ImmutableConflictGraph.createSafeList(regions, true, false));
    }

    private ImmutableConflictGraph(ImmutableConflictGraph original, List<Region> regions) {
        this.regions = regions;
    }

    @Override
    protected List<Region> regions() {
        return this.regions;
    }

    public final ImmutableConflictGraph withRegions(Region ... elements) {
        List<Region> newValue = ImmutableConflictGraph.createUnmodifiableList(false, ImmutableConflictGraph.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableConflictGraph(this, newValue);
    }

    public final ImmutableConflictGraph withRegions(Iterable<? extends Region> elements) {
        if (this.regions == elements) {
            return this;
        }
        List<Region> newValue = ImmutableConflictGraph.createUnmodifiableList(false, ImmutableConflictGraph.createSafeList(elements, true, false));
        return new ImmutableConflictGraph(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConflictGraph && this.equalTo((ImmutableConflictGraph)another);
    }

    private boolean equalTo(ImmutableConflictGraph another) {
        return this.regions.equals(another.regions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.regions.hashCode();
        return h;
    }

    public String toString() {
        return "ConflictGraph{regions=" + this.regions + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<Region, Set<Region>> conflicts() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableConflictGraph immutableConflictGraph = this;
            synchronized (immutableConflictGraph) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.conflicts = Objects.requireNonNull(super.conflicts(), "conflicts");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.conflicts;
    }

    public static ImmutableConflictGraph of(List<Region> regions) {
        return ImmutableConflictGraph.of(regions);
    }

    public static ImmutableConflictGraph of(Iterable<? extends Region> regions) {
        return new ImmutableConflictGraph(regions);
    }

    public static ImmutableConflictGraph copyOf(ConflictGraph instance) {
        if (instance instanceof ImmutableConflictGraph) {
            return (ImmutableConflictGraph)instance;
        }
        return ImmutableConflictGraph.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ConflictGraph", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Region> regions = new ArrayList<Region>();

        private Builder() {
        }

        public final Builder from(ConflictGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllRegions(instance.regions());
            return this;
        }

        public final Builder addRegions(Region element) {
            this.regions.add(Objects.requireNonNull(element, "regions element"));
            return this;
        }

        public final Builder addRegions(Region ... elements) {
            for (Region element : elements) {
                this.regions.add(Objects.requireNonNull(element, "regions element"));
            }
            return this;
        }

        public final Builder regions(Iterable<? extends Region> elements) {
            this.regions.clear();
            return this.addAllRegions(elements);
        }

        public final Builder addAllRegions(Iterable<? extends Region> elements) {
            for (Region region : elements) {
                this.regions.add(Objects.requireNonNull(region, "regions element"));
            }
            return this;
        }

        public ImmutableConflictGraph build() {
            return new ImmutableConflictGraph(null, ImmutableConflictGraph.createUnmodifiableList(true, this.regions));
        }
    }
}

