/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.pseudoknots;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.immutables.value.Value;
import pl.poznan.put.structure.pseudoknots.ImmutableConflictGraph;
import pl.poznan.put.structure.pseudoknots.Region;
import pl.poznan.put.structure.pseudoknots.dp.ConflictClique;
import pl.poznan.put.structure.pseudoknots.dp.ImmutableConflictClique;

@Value.Immutable
public abstract class ConflictGraph {
    public static boolean isConflicting(Region first, Region second) {
        int firstBegin = first.begin();
        int firstEnd = first.end();
        int secondBegin = second.begin();
        int secondEnd = second.end();
        if (firstBegin < secondBegin && firstEnd < secondEnd && secondBegin < firstEnd) {
            return true;
        }
        if (secondBegin < firstBegin && secondEnd < firstEnd) {
            return firstBegin < secondEnd;
        }
        return false;
    }

    @Value.Parameter(order=1)
    protected abstract List<Region> regions();

    public final void removeRegion(Region region) {
        if (this.conflicts().containsKey(region)) {
            for (Region conflicted : this.conflicts().get(region)) {
                this.conflicts().get(conflicted).remove(region);
                if (!this.conflicts().get(conflicted).isEmpty()) continue;
                this.conflicts().remove(conflicted);
            }
            this.conflicts().remove(region);
        }
    }

    public final Set<Region> conflictsWith(Region region) {
        return this.conflicts().containsKey(region) ? Collections.unmodifiableSet(this.conflicts().get(region)) : Collections.emptySet();
    }

    public final Set<Region> regionsWithConflicts() {
        return Collections.unmodifiableSet(this.conflicts().keySet());
    }

    public final boolean hasConflicts() {
        return !this.conflicts().isEmpty();
    }

    public final boolean hasConflicts(Region region) {
        return this.conflicts().containsKey(region);
    }

    public final List<ConflictClique> conflictCliques() {
        ArrayList<ConflictClique> conflictCliques = new ArrayList<ConflictClique>();
        HashSet<Region> seen = new HashSet<Region>();
        for (Region region : this.conflicts().keySet()) {
            if (seen.contains(region)) continue;
            HashSet<Region> todo = new HashSet<Region>();
            todo.add(region);
            HashSet<Region> done = new HashSet<Region>();
            while (!CollectionUtils.isEqualCollection(todo, done)) {
                ArrayList next = new ArrayList();
                for (Region r : todo) {
                    next.addAll(this.conflicts().get(r));
                    done.add(r);
                }
                todo.addAll(next);
            }
            if (done.size() > 1) {
                conflictCliques.add(ImmutableConflictClique.of(done));
            }
            seen.addAll(done);
        }
        return conflictCliques;
    }

    public final ConflictGraph simplified() {
        ArrayList<Region> toRemove = new ArrayList<Region>();
        ArrayList<Region> toAdd = new ArrayList<Region>();
        ImmutableConflictGraph result = ImmutableConflictGraph.copyOf(this);
        do {
            ArrayList<Region> conflicted = new ArrayList<Region>(result.regionsWithConflicts());
            toRemove.clear();
            toAdd.clear();
            for (int i = 0; i < conflicted.size(); ++i) {
                Region ri = (Region)conflicted.get(i);
                int riBegin = ri.begin();
                int riEnd = ri.end();
                for (int j = i + 1; j < conflicted.size(); ++j) {
                    boolean b2;
                    Region rj = (Region)conflicted.get(j);
                    int rjBegin = rj.begin();
                    int rjEnd = rj.end();
                    boolean b1 = riBegin <= rjBegin && riEnd >= rjEnd;
                    boolean bl = b2 = rjBegin <= riBegin && rjEnd >= riEnd;
                    if (!b1 && !b2 || !CollectionUtils.isEqualCollection(result.conflictsWith(ri), result.conflictsWith(rj))) continue;
                    toRemove.add(ri);
                    toRemove.add(rj);
                    toAdd.add(Region.merge(ri, rj));
                    break;
                }
                if (!toRemove.isEmpty()) break;
            }
            if (toRemove.isEmpty()) continue;
            ArrayList<Region> regionsCopy = new ArrayList<Region>(this.regions());
            regionsCopy.removeAll(toRemove);
            regionsCopy.addAll(toAdd);
            result = ImmutableConflictGraph.of(regionsCopy);
        } while (!toRemove.isEmpty());
        return result;
    }

    @Value.Lazy
    protected Map<Region, Set<Region>> conflicts() {
        if (this.regions().size() < 2) {
            return Collections.emptyMap();
        }
        HashMap<Region, Set<Region>> map = new HashMap<Region, Set<Region>>();
        Iterator iterator = CombinatoricsUtils.combinationsIterator((int)this.regions().size(), (int)2);
        Iterable iterable = () -> iterator;
        StreamSupport.stream(iterable.spliterator(), false).map(ints -> Pair.of((Object)this.regions().get(ints[0]), (Object)this.regions().get(ints[1]))).filter(pair -> ConflictGraph.isConflicting((Region)pair.getLeft(), (Region)pair.getRight())).flatMap(pair -> Stream.of(pair, Pair.of((Object)((Region)pair.getRight()), (Object)((Region)pair.getLeft())))).distinct().forEach(pair -> {
            map.putIfAbsent((Region)pair.getLeft(), new HashSet());
            ((Set)map.get(pair.getLeft())).add((Region)pair.getRight());
        });
        return map;
    }
}

