/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.List;
import org.immutables.value.Value;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.DotBracketFromPdb;
import pl.poznan.put.structure.formats.Strand;

@Value.Immutable
public abstract class StrandView
implements Strand {
    @Override
    @Value.Parameter(order=1)
    public abstract String name();

    @Override
    public final String description() {
        if (this.parent() instanceof DotBracketFromPdb) {
            DotBracketFromPdb fromPdb = (DotBracketFromPdb)this.parent();
            PdbResidueIdentifier from = fromPdb.identifier(fromPdb.symbols().get(this.begin()));
            PdbResidueIdentifier to = fromPdb.identifier(fromPdb.symbols().get(this.end() - 1));
            return String.format("%s %s %s %s %s", from, to, this.sequence(), this.structure(), this.sequenceRY());
        }
        return String.format("%d %d %s %s %s", this.begin() + 1, this.end(), this.sequence(), this.structure(), this.sequenceRY());
    }

    @Override
    @Value.Parameter(order=3)
    public abstract int begin();

    @Override
    @Value.Parameter(order=4)
    public abstract int end();

    @Value.Parameter(order=2)
    public abstract DotBracket parent();

    @Override
    @Value.Lazy
    public List<DotBracketSymbol> symbols() {
        return this.parent().symbols().subList(this.begin(), this.end());
    }

    public final String toString() {
        return String.format(">strand_%s\n%s\n%s", this.name(), this.sequence(), this.structure());
    }
}

