/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.structure.formats;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import pl.poznan.put.structure.DotBracketSymbol;
import pl.poznan.put.structure.formats.DotBracket;
import pl.poznan.put.structure.formats.ImmutableTerminalMissing;
import pl.poznan.put.structure.formats.TerminalMissing;

public interface Strand
extends DotBracket {
    public String name();

    default public TerminalMissing missingBegin() {
        ArrayList<DotBracketSymbol> missing = new ArrayList<DotBracketSymbol>();
        for (DotBracketSymbol symbol : this.symbols()) {
            if (!symbol.isMissing()) break;
            missing.add(symbol);
        }
        return ImmutableTerminalMissing.of(missing);
    }

    default public TerminalMissing missingEnd() {
        DotBracketSymbol symbol;
        ArrayList<DotBracketSymbol> missing = new ArrayList<DotBracketSymbol>();
        for (int i = this.symbols().size() - 1; i >= 0 && (symbol = this.symbols().get(i)).isMissing(); --i) {
            missing.add(symbol);
        }
        return ImmutableTerminalMissing.of(missing);
    }

    default public String description() {
        return String.format("%d %d %s %s %s", this.symbols().get(0).index(), this.symbols().get(this.symbols().size() - 1).index(), this.sequence(), this.structure(), this.sequenceRY());
    }

    default public int begin() {
        return this.symbols().isEmpty() ? 1 : this.symbols().get(0).index();
    }

    default public int end() {
        return this.symbols().isEmpty() ? 1 : this.symbols().get(this.symbols().size() - 1).index();
    }

    default public boolean isSingleStrand() {
        Map<DotBracketSymbol, DotBracketSymbol> pairs = this.pairs();
        return this.symbols().stream().filter(DotBracketSymbol::isPairing).map(pairs::get).noneMatch(symbol -> this.symbols().contains(symbol));
    }

    default public String sequenceRY() {
        return this.sequence().chars().mapToObj(i -> Character.valueOf((char)i)).map(character -> character.charValue() == 'A' || character.charValue() == 'G' ? "R" : "Y").collect(Collectors.joining());
    }
}

